---@meta

---@class FB1DecorationObjectList
---@field DecorationObjectList TArray<FB1EntityId>
local FB1DecorationObjectList = {}



---@class FB1DecorationSpawnCount
---@field DecorationSpawnCountData TMap<FName, int32>
local FB1DecorationSpawnCount = {}



---@class FB1DecorationSpawnCountList
---@field DecorationSpawnCountList TMap<FName, FB1DecorationSpawnCount>
local FB1DecorationSpawnCountList = {}



---@class FB1ExportInteractionForPlugin
local FB1ExportInteractionForPlugin = {}


---@class FB1FilterContext
---@field SelfEntityId FB1EntityId
---@field PickedEntityId FB1EntityId
---@field ImpactPoint FVector
---@field InteractionId FName
---@field Tags TArray<FName>
---@field bUsePickedEntityIdCheckingObjectSlot boolean
---@field bDoNotCheckPickedEntityId boolean
---@field bResetContainerBeforeAdd boolean
local FB1FilterContext = {}



---@class FB1FilterTargetInfo
---@field EntityID FB1EntityId
---@field TargetLocation FVector
---@field InteractionSlot FB2TargetSlotParam
---@field ObjectSlot FB2TargetSlotParam
---@field EntityToTargetDistance float
---@field InteractionId FName
local FB1FilterTargetInfo = {}



---@class FB1MissionConditionTriggerList
---@field ConditionTriggers TArray<FB1MissionConditionTrigger>
local FB1MissionConditionTriggerList = {}



---@class FB1MissionIdList
---@field MissionIds TArray<FB1MissionId>
local FB1MissionIdList = {}



---@class FB1RumorIdList
---@field OwnedRumorIdList TArray<FB1RumorId>
---@field CurrentRumorCount int32
local FB1RumorIdList = {}



---@class FB1SiteAccessRecordData
---@field EnteredTickTime int64
---@field ExitedTickTime int64
local FB1SiteAccessRecordData = {}



---@class FB1SiteEventIdList
---@field SiteEventIdList TArray<FB1SiteEventId>
local FB1SiteEventIdList = {}



---@class FB1StartCraftingContext
---@field RecipeGroupId FName
---@field RecipeId FName
---@field PrecedingInteractionBagId FName
---@field Step int32
---@field CraftObjectEntityId FB1EntityId
---@field WorkbenchEntityId FB1EntityId
---@field CustomName FText
---@field CustomDescription FText
local FB1StartCraftingContext = {}



---@class FB1StatRewardCacheData
---@field StatRewardDataMap TMap<FName, int64>
local FB1StatRewardCacheData = {}



---@class FB1TargetResult
---@field TargetInfos TArray<FB1FilterTargetInfo>
local FB1TargetResult = {}



---@class FB2AOIGridInfo
local FB2AOIGridInfo = {}


---@class FB2ActionKey
---@field InteractionQueueId int64
---@field InteractionSequenceIndex int32
---@field ActionIndex int32
local FB2ActionKey = {}



---@class FB2Action_Base
---@field ActionId FName
---@field State EB2ActionState
---@field Result EB2InteractionResult
---@field SelfEntityId FB1EntityId
---@field TargetEntityId FB1EntityId
---@field NonTargetLocation FVector
---@field Action FB1ActionInfo
---@field TickCalcValue float
---@field CurrentNotifyIndex int32
---@field AsyncLoadAnimInfo TArray<FB1AsyncLoadAnimInfo>
---@field AddActionTimeInterval float
---@field AccumAddActionTime float
---@field StartActionTickTime int64
---@field ActionKey FB2ActionKey
---@field TimeTaskId FB1TimeTaskId
---@field IsForceCancelable boolean
---@field TalkInstanceId FB1TalkInstanceId
---@field bIsWaitFinishEvent boolean
local FB2Action_Base = {}



---@class FB2Action_BookRead : FB2Action_Base
---@field CurrentSectionType EB1LoopAnimType
---@field CurrentAnimTime float
---@field BookReadStartTickTime int64
---@field BookDtId FName
---@field RootAnimId FName
---@field RootAnimMontageName FName
---@field BookAnimId FName
---@field BookAnimMontageName FName
---@field ProgressTime float
local FB2Action_BookRead = {}



---@class FB2Action_Buy : FB2Action_Base
---@field GrabId FName
---@field PickUpAnimId FName
---@field GrabLoopAnimId FName
---@field AnimMontageName FName
---@field bUseFakeObject boolean
---@field FakeObjectList TArray<FB1EntityId>
local FB2Action_Buy = {}



---@class FB2Action_ChangeCostume : FB2Action_Base
---@field CostumeId FName
---@field IsRemove boolean
local FB2Action_ChangeCostume = {}



---@class FB2Action_ChangeOutfitCategory : FB2Action_Base
---@field OutfitCategory EB1OutfitCategory
---@field IsRemove boolean
local FB2Action_ChangeOutfitCategory = {}



---@class FB2Action_ChangePosture : FB2Action_Base
---@field PostureId FName
---@field ChangePostureState FB1PostureState
---@field PostureAnimName FName
---@field PostureAnimId FName
---@field CurrentAnimTime float
---@field bIsOverrideAnim boolean
---@field bIsCancelCondition boolean
---@field bUseSafeExitLocation boolean
---@field SafeExitLocation FVector
---@field bIsDriverExit boolean
local FB2Action_ChangePosture = {}



---@class FB2Action_ChangePostureSit : FB2Action_ChangePosture
local FB2Action_ChangePostureSit = {}


---@class FB2Action_ChangeVehiclePartState : FB2Action_Base
---@field VehiclePartType EB1VehiclePartType
---@field PartState FName
---@field CurrentAnimTime float
---@field TotalPlayTimeLength float
local FB2Action_ChangeVehiclePartState = {}



---@class FB2Action_CleanDusty : FB2Action_Base
---@field EffectiveDistance float
---@field AddingDustyValue float
---@field ChangeNormalStateObjectTag FName
local FB2Action_CleanDusty = {}



---@class FB2Action_ContinueCrafting : FB2Action_Base
---@field CraftingSlotName FName
---@field CraftObjectEntityId FB1EntityId
---@field ContinueCraftingMethod EB2ContinueCraftingMethod
local FB2Action_ContinueCrafting = {}



---@class FB2Action_Coop : FB2Action_Base
---@field CoopId FName
---@field InteractionBagId FName
---@field CoopType EB1CoopType
---@field LastCoopResult EB1CoopResult
local FB2Action_Coop = {}



---@class FB2Action_CoopSelect : FB2Action_Base
---@field CoopId FName
---@field InteractionBagId FName
---@field LastCoopResult EB1CoopResult
---@field bSendPacket boolean
---@field bRestore boolean
local FB2Action_CoopSelect = {}



---@class FB2Action_CraftBulidMode : FB2Action_Base
---@field CraftBuildMode EB2CraftBuildMode
local FB2Action_CraftBulidMode = {}



---@class FB2Action_Delay : FB2Action_Base
---@field Delay float
---@field RemainTime float
local FB2Action_Delay = {}



---@class FB2Action_Die : FB2Action_Base
local FB2Action_Die = {}


---@class FB2Action_Eat : FB2Action_Base
---@field CurrentSectionType EB1LoopAnimType
---@field CurrentAnimTime float
---@field RootAnimId FName
---@field RootAnimMontageName FName
---@field HeadAnimId FName
---@field HeadAnimMontageName FName
---@field ProgressTime float
local FB2Action_Eat = {}



---@class FB2Action_EditCharacter : FB2Action_Base
---@field CharacterCustomizeCategory EB1CharacterCustomizationCategory
local FB2Action_EditCharacter = {}



---@class FB2Action_GenerateMotion : FB2Action_Base
local FB2Action_GenerateMotion = {}


---@class FB2Action_GrabInventoryObject : FB2Action_Base
---@field GrapDtId FName
---@field PickUpAnimId FName
---@field GrabLoopAnimId FName
---@field AnimMontageName FName
local FB2Action_GrabInventoryObject = {}



---@class FB2Action_LaunchCraft : FB2Action_Base
---@field CraftingId FName
local FB2Action_LaunchCraft = {}



---@class FB2Action_LevelSequence : FB2Action_Base
---@field LevelSequenceId FName
local FB2Action_LevelSequence = {}



---@class FB2Action_MoveWithVehicle : FB2Action_Base
local FB2Action_MoveWithVehicle = {}


---@class FB2Action_PickUp : FB2Action_Base
---@field GrabId FName
---@field PickUpAnimId FName
---@field GrabLoopAnimId FName
---@field AnimMontageName FName
---@field CurrentAnimTime float
---@field TotalPlayLength float
local FB2Action_PickUp = {}



---@class FB2Action_PickUpCharacter : FB2Action_Base
---@field GrabId FName
---@field PickUpAnimId FName
---@field GrabLoopAnimId FName
---@field AnimMontageName FName
---@field CurrentAnimTime float
---@field TotalPlayLength float
local FB2Action_PickUpCharacter = {}



---@class FB2Action_PlayAnim : FB2Action_Base
---@field AnimationId FName
---@field LoopCount int32
---@field RemainLoopCount int32
---@field StartLocation FVector
---@field StartRotation FRotator
---@field AnimMontageName FName
---@field SectionName FName
---@field PlayingComponentName FName
---@field TotalPlayLength float
---@field LoopPlayLength float
---@field RateScale float
local FB2Action_PlayAnim = {}



---@class FB2Action_PlayAnimContext : FB2Action_PlayAnim
local FB2Action_PlayAnimContext = {}


---@class FB2Action_PlayGeneratedMotion : FB2Action_Base
---@field GeneratedMotionIndex int32
---@field CurrentAnimTime float
local FB2Action_PlayGeneratedMotion = {}



---@class FB2Action_PlayVATAnim : FB2Action_Base
---@field AnimSequenceId FName
---@field CurrentAnimTime float
---@field TotalPlayLength float
local FB2Action_PlayVATAnim = {}



---@class FB2Action_PlayVideo : FB2Action_Base
---@field VideoId EB1VideoPlayerId
local FB2Action_PlayVideo = {}



---@class FB2Action_PopupMessage : FB2Action_Base
---@field PopupId FName
---@field PopupCategory FName
local FB2Action_PopupMessage = {}



---@class FB2Action_ProgressCrafting : FB2Action_PlayAnim
---@field ObjectEntityId FB1EntityId
---@field InitialProgress float
---@field PrevTotalProgressTime float
local FB2Action_ProgressCrafting = {}



---@class FB2Action_PutDown : FB2Action_Base
---@field GrabEntityId FB1EntityId
---@field GrabId FName
---@field PutDownAnimId FName
---@field AnimMontageName FName
---@field GrabAnimMontageName FName
---@field CurrentAnimTime float
---@field TotalPlayLength float
---@field PutDownLocation FVector
---@field PutDownRotation FRotator
---@field PutDownMethod EB2PutDownMethod
---@field bUseSelectedMethod boolean
---@field PostureAnimId FName
---@field PostureAnimMontageName FName
local FB2Action_PutDown = {}



---@class FB2Action_PutDownDestroy : FB2Action_PutDown
local FB2Action_PutDownDestroy = {}


---@class FB2Action_PutDownInventoryObject : FB2Action_Base
---@field GrabId FName
---@field PutDownAnimId FName
---@field AnimMontageName FName
---@field CurrentAnimTime float
---@field TotalPlayLength float
---@field FloorPutDownLocation FVector
local FB2Action_PutDownInventoryObject = {}



---@class FB2Action_RabbitHole : FB2Action_Base
---@field RabbitHoleId FName
---@field FinishTime int32
---@field FinishTick int64
local FB2Action_RabbitHole = {}



---@class FB2Action_RegisterPocketMarketItem : FB2Action_Base
---@field Price int64
local FB2Action_RegisterPocketMarketItem = {}



---@class FB2Action_RemoveCostumeByActionReason : FB2Action_Base
local FB2Action_RemoveCostumeByActionReason = {}


---@class FB2Action_RequestEnterVehicle : FB2Action_Base
local FB2Action_RequestEnterVehicle = {}


---@class FB2Action_RotateTo : FB2Action_Base
---@field bDoMove boolean
---@field bDoRotate boolean
---@field TargetLocation FVector
---@field TargetYaw float
local FB2Action_RotateTo = {}



---@class FB2Action_RotateToContext : FB2Action_Base
---@field FeetLocation FVector
---@field TargetRotation FRotator
local FB2Action_RotateToContext = {}



---@class FB2Action_RunAway : FB2Action_WalkTo
local FB2Action_RunAway = {}


---@class FB2Action_SelectSlotOwnership : FB2Action_Base
---@field InteractionBagId FName
---@field SlotOwnershipTag FName
---@field bSendPacket boolean
---@field bRestore boolean
local FB2Action_SelectSlotOwnership = {}



---@class FB2Action_Sit : FB2Action_Base
---@field SitDuration float
---@field ProgressTime float
local FB2Action_Sit = {}



---@class FB2Action_Sleep : FB2Action_Base
---@field WakeUpTime int64
---@field ProgressTime float
local FB2Action_Sleep = {}



---@class FB2Action_SpawnVehicle : FB2Action_Base
local FB2Action_SpawnVehicle = {}


---@class FB2Action_StartCrafting : FB2Action_Base
---@field RecipeId FName
local FB2Action_StartCrafting = {}



---@class FB2Action_TalkContext : FB2Action_PlayAnim
---@field bFullBody boolean
---@field bOverridedMontagePlayTime boolean
---@field OverridedMontageTimeOut float
---@field CurrentMontageTimeOut float
---@field TalkStartScriptIds TArray<FName>
---@field TalkFinishScriptIds TArray<FName>
local FB2Action_TalkContext = {}



---@class FB2Action_TeleportTo : FB2Action_Base
---@field TeleportTargetEntityId FB1EntityId
---@field To FVector
local FB2Action_TeleportTo = {}



---@class FB2Action_UpdateAging : FB2Action_Base
---@field bSubscribed boolean
local FB2Action_UpdateAging = {}



---@class FB2Action_WaitCoopResponse : FB2Action_Base
local FB2Action_WaitCoopResponse = {}


---@class FB2Action_WaitForAsyncLoad : FB2Action_Base
---@field AsyncLoadId FB1AsyncLoadId
local FB2Action_WaitForAsyncLoad = {}



---@class FB2Action_WaitTalkPositioning : FB2Action_Base
---@field StartedTime FDateTime
local FB2Action_WaitTalkPositioning = {}



---@class FB2Action_WaitTalkSequence : FB2Action_Base
---@field StartedTime FDateTime
local FB2Action_WaitTalkSequence = {}



---@class FB2Action_WalkAround : FB2Action_WalkTo
local FB2Action_WalkAround = {}


---@class FB2Action_WalkAroundLocation : FB2Action_WalkToLocation
---@field MinRadius float
---@field MaxRadius float
---@field FindPathRetryCount int32
---@field bIsPathFinding boolean
local FB2Action_WalkAroundLocation = {}



---@class FB2Action_WalkTo : FB2Action_Base
---@field From FVector
---@field To FVector
---@field bUseSprint boolean
---@field bWaitRequestPathResult boolean
---@field WalkToState EB2WalkToState
---@field MoveOver FB2MoveOver
---@field OffsetDistance float
local FB2Action_WalkTo = {}



---@class FB2Action_WalkToCompany : FB2Action_WalkTo
local FB2Action_WalkToCompany = {}


---@class FB2Action_WalkToContext : FB2Action_WalkTo
local FB2Action_WalkToContext = {}


---@class FB2Action_WalkToDirtyPlace : FB2Action_WalkTo
local FB2Action_WalkToDirtyPlace = {}


---@class FB2Action_WalkToHome : FB2Action_WalkTo
---@field DespawnSpawnerEntityId FB1EntityId
---@field PreviousLocation FVector
local FB2Action_WalkToHome = {}



---@class FB2Action_WalkToLocation : FB2Action_WalkTo
local FB2Action_WalkToLocation = {}


---@class FB2Action_WalkToNearby : FB2Action_WalkTo
---@field DistanceRangeMin float
---@field DistanceRangeMax float
local FB2Action_WalkToNearby = {}



---@class FB2Action_WalkToNearestCityGraph : FB2Action_WalkTo
local FB2Action_WalkToNearestCityGraph = {}


---@class FB2Action_WalkToNearestRoad : FB2Action_WalkTo
local FB2Action_WalkToNearestRoad = {}


---@class FB2Action_WalkToPortal : FB2Action_WalkTo
local FB2Action_WalkToPortal = {}


---@class FB2Action_WalkToSharedSiteSpawner : FB2Action_WalkTo
---@field ToMeshSpawnerEntityId FB1EntityId
---@field SpawnMeshDescriptionId FName
local FB2Action_WalkToSharedSiteSpawner = {}



---@class FB2Action_WalkToSite : FB2Action_WalkTo
local FB2Action_WalkToSite = {}


---@class FB2Action_WalkToSpawner : FB2Action_WalkTo
---@field DespawnSpawnerEntityId FB1EntityId
local FB2Action_WalkToSpawner = {}



---@class FB2Action_WalkToSubway : FB2Action_WalkTo
local FB2Action_WalkToSubway = {}


---@class FB2Action_WalkToVehicle : FB2Action_WalkTo
---@field NextDest TArray<FVector>
local FB2Action_WalkToVehicle = {}



---@class FB2Action_WalkTo_NonCancelable : FB2Action_WalkTo
---@field bRequestPathFailed boolean
local FB2Action_WalkTo_NonCancelable = {}



---@class FB2Action_Work : FB2Action_PlayAnim
local FB2Action_Work = {}


---@class FB2AddSkillExpParams
local FB2AddSkillExpParams = {}


---@class FB2AnimMontageInstance
---@field MontageId FName
---@field GroupName FName
---@field DataId FName
---@field TotalPlayLength float
---@field RateScale float
---@field BlendOutTime float
---@field AnimMontageParam FB2AnimMontageParam
---@field Sections TArray<FB1AnimSection>
---@field State EB2MontageState
---@field PrevPosition float
---@field Position float
---@field RemainBlendTime float
---@field NextSections TArray<int32>
---@field PrevSections TArray<int32>
local FB2AnimMontageInstance = {}



---@class FB2AnimMontageParam
---@field AnimId FName
---@field SelfId FB1EntityId
---@field TargetId FB1EntityId
---@field ActionOwnerId FB1EntityId
---@field AnimTag FName
---@field bNeedPacket boolean
---@field bWithMotionWarp boolean
local FB2AnimMontageParam = {}



---@class FB2AnimNotifyEvent_Base
---@field NotifyType EB1NotyfyType
---@field TriggerTime float
---@field duration float
---@field State EB1AnimNotifyEventState
---@field SelfEntityId FB1EntityId
---@field TargetEntityId FB1EntityId
---@field bIsBeginNotify boolean
local FB2AnimNotifyEvent_Base = {}



---@class FB2AnimNotifyEvent_ChangeState : FB2AnimNotifyEvent_Base
---@field Target EB1BaseObject
---@field ChangedStateGroupName FName
---@field ChangeStateName FName
local FB2AnimNotifyEvent_ChangeState = {}



---@class FB2AnimNotifyEvent_EnterVehicle : FB2AnimNotifyEvent_Base
---@field VehicleSeat FName
local FB2AnimNotifyEvent_EnterVehicle = {}



---@class FB2AnimNotifyEvent_ExitVehicle : FB2AnimNotifyEvent_Base
---@field VehicleSeat FName
local FB2AnimNotifyEvent_ExitVehicle = {}



---@class FB2AnimNotifyEvent_LadderRightStep : FB2AnimNotifyEvent_Base
local FB2AnimNotifyEvent_LadderRightStep = {}


---@class FB2AnimNotifyEvent_LoopEnd : FB2AnimNotifyEvent_Base
local FB2AnimNotifyEvent_LoopEnd = {}


---@class FB2AnimNotifyEvent_PlayAnim : FB2AnimNotifyEvent_Base
---@field BeginAnimInfo FB1PlayAnimInfo
---@field EndAnimInfo FB1PlayAnimInfo
local FB2AnimNotifyEvent_PlayAnim = {}



---@class FB2AnimNotifyEvent_PlayStaticMeshAnim : FB2AnimNotifyEvent_Base
---@field Info FB1PlayStaticAnimInfo
---@field CurrentAnimPlayTime float
---@field AnimEndTime float
local FB2AnimNotifyEvent_PlayStaticMeshAnim = {}



---@class FB2AnimNotifyEvent_RunScript : FB2AnimNotifyEvent_Base
local FB2AnimNotifyEvent_RunScript = {}


---@class FB2AnimNotifyEvent_XXX : FB2AnimNotifyEvent_Base
local FB2AnimNotifyEvent_XXX = {}


---@class FB2AnimRestoreTransform
---@field bIsSet boolean
---@field Location FVector
---@field Rotation FRotator
local FB2AnimRestoreTransform = {}



---@class FB2AreaLocationData
---@field Location FVector
---@field IsUsed boolean
local FB2AreaLocationData = {}



---@class FB2AvoidanceHandler
---@field EntityID FB1EntityId
---@field State EB2AvoidanceState
---@field AvoidanceVeloicty FVector
---@field SafeLocation FVector
---@field LockedVelocity FVector
---@field AvoidanceAccTime float
local FB2AvoidanceHandler = {}



---@class FB2BuffTickStatDelta
---@field StatDiffs TMap<FName, float>
local FB2BuffTickStatDelta = {}



---@class FB2CacheLastInteractionInfo
local FB2CacheLastInteractionInfo = {}


---@class FB2CharacterGenerateParam
local FB2CharacterGenerateParam = {}


---@class FB2CharacterHouseholdParam
local FB2CharacterHouseholdParam = {}


---@class FB2CheckCanTraitAddParams
local FB2CheckCanTraitAddParams = {}


---@class FB2CheckHasAgeAvailableParams
local FB2CheckHasAgeAvailableParams = {}


---@class FB2ChoiceCardEvent
---@field ChoiceCardId FName
---@field SelfEntityId FB1EntityId
---@field TargetEntityId FB1EntityId
---@field AnswerScriptIds TArray<FName>
local FB2ChoiceCardEvent = {}



---@class FB2CityGraphTrafficLane
---@field RoadIndex int32
---@field LaneIndex int32
---@field Category EB1CityGraphCategory
---@field EndPoints FVector
---@field bComplex boolean
---@field Space float
---@field RemainingSpace float
---@field Vehicles TArray<FB1EntityId>
local FB2CityGraphTrafficLane = {}



---@class FB2CoopCharacterInfo
---@field CharacterId FB1EntityId
---@field CurrentState EB1CoopCharacterState
local FB2CoopCharacterInfo = {}



---@class FB2CoopPendingTask
---@field CharacterId FB1EntityId
---@field TargetId FB1EntityId
---@field PickedImpactPoint FVector
---@field InteractionBagId FName
---@field ForceCurrentInteractionCancel boolean
---@field PushedTime int64
---@field OffsetTime int64
local FB2CoopPendingTask = {}



---@class FB2EntityCollection
---@field Type EB2EntityType
---@field EntityArray TArray<TWeakObjectPtr<UB2Entity>>
local FB2EntityCollection = {}



---@class FB2EntityTag
---@field Value FName
---@field Expire FDateTime
local FB2EntityTag = {}



---@class FB2EventTriggerInfo
---@field Type EB2TriggerType
---@field BeginTime uint32
---@field EndTime uint32
---@field IsDone boolean
---@field Conditions TArray<FB1Condition>
---@field Executes TArray<FB1Execute>
local FB2EventTriggerInfo = {}



---@class FB2ExecuteContextList
---@field bKeepPushingSchedule boolean
---@field LastCheckedIndex int32
---@field ContextList TArray<FB1ServiceExecuteContext>
local FB2ExecuteContextList = {}



---@class FB2ExecutingTalkParam
---@field Target FB1EntityId
---@field InteractionBagId FName
---@field ChitchatRelationshipId FName
---@field ChitchatRelationshipValue float
---@field IsTalkSequenceCompleted boolean
local FB2ExecutingTalkParam = {}



---@class FB2Fire
---@field OwnerEntityId FB1EntityId
---@field SpreadLevel int32
---@field SpreadedEntityIdList TSet<FB1EntityId>
---@field SpreadedFailEntityIdList TSet<FB1EntityId>
---@field OutofBoundEntityIdList TSet<FB1EntityId>
---@field NearEntityIdList TMap<FB1EntityId, float>
---@field OriginPos FVector
---@field FloorFireSpreadTime float
---@field FloorSpreadEnd boolean
---@field WallFireSpreadTime float
---@field WallSpreadEnd boolean
---@field EntitySpreadEnd boolean
---@field SpawnSuccessEntityId FB1EntityId
---@field FireId FB1FireId
local FB2Fire = {}



---@class FB2FirstTalkParam
---@field Self FB1EntityId
---@field Target FB1EntityId
---@field CoopId FName
---@field InteractionBagId FName
local FB2FirstTalkParam = {}



---@class FB2InteractionHistory
---@field ExecuteTickList TArray<int64>
local FB2InteractionHistory = {}



---@class FB2InteractionQueue
---@field InteractionQueueId int64
---@field OwnerEntityId FB1EntityId
---@field PickedEntityId FB1EntityId
---@field ImpactPoint FVector
---@field InteractionBagId FName
---@field PlayReason EB1InteractionPlayReason
---@field CoopSchedulerId FB1EntityId
---@field PickedEntityStateGroupId FName
---@field PickedEntityStateId FName
---@field bInsertFront boolean
local FB2InteractionQueue = {}



---@class FB2InteractionSequenceResult
---@field Result EB2InteractionResult
---@field FailReason EB2InteractionFailReason
---@field CancelReason EB1InteractionCancelReason
local FB2InteractionSequenceResult = {}



---@class FB2JobEntityPool
---@field ServiceEntityList TSet<FB1EntityId>
local FB2JobEntityPool = {}



---@class FB2LadderHandler
---@field EntityID FB1EntityId
---@field CurrentPhase EB1LadderAnimPhase
---@field Param FB2LadderParam
---@field bUpward boolean
---@field LadderHeight float
---@field TargetLoopLadderStepCount int32
---@field CurrenLoopLadderStepCount int32
---@field bLoopAnimEnded boolean
---@field bExitAnimEnded boolean
---@field TargetStartCalibratingZValue float
---@field CurrentStartCalibratingTime float
---@field TargetStartCalibratingTime float
---@field CurrentEndCalibratingTime float
---@field TargetEndCalibratingTime float
local FB2LadderHandler = {}



---@class FB2LadderParam
---@field EnterPosition FVector
---@field EnterRotation FRotator
---@field EnterLadderEntityId FB1EntityId
---@field ExitPosition FVector
---@field ExitRotation FRotator
---@field ExitLadderEntityId FB1EntityId
---@field FloorCheckHeightArray TArray<float>
local FB2LadderParam = {}



---@class FB2LazyChangeEntityStateData
---@field State EB2EntityState
---@field Reason EB2EntityStateChangeReason
local FB2LazyChangeEntityStateData = {}



---@class FB2MainInteractionData
---@field MainInteractionId FName
---@field InteractionResult EB2InteractionResult
local FB2MainInteractionData = {}



---@class FB2MeetingMatchedData
---@field MeetingHostCharacterId FB1EntityId
---@field MeetingGuestCharacterId FB1EntityId
---@field MeetingSiteId FName
local FB2MeetingMatchedData = {}



---@class FB2MeetingWatingData
---@field MeetingHostCharacterId FB1EntityId
---@field MeetingAbleGuestIds TArray<FB1EntityId>
---@field MeetingSuccessGuestId FB1EntityId
---@field MeetingRuleData FB1MeetingRuleData
---@field MeetingMatchingStep EB2MeetingMatchingStep
local FB2MeetingWatingData = {}



---@class FB2MotionWarpingParam
---@field bEnabled boolean
---@field StartLocation FVector
---@field EndLocation FVector
---@field StartRotation FQuat
---@field EndRotation FQuat
---@field FinalDestination FVector
---@field TotalTime float
---@field AccTime float
---@field BlendTime float
---@field BlendAlpha float
---@field AccRootMotion FTransform
---@field MontageId FName
local FB2MotionWarpingParam = {}



---@class FB2MoveOver
---@field TargetLocation FVector
---@field MoveOverState EB2MoveOverState
local FB2MoveOver = {}



---@class FB2MoveRequest
---@field Pos FVector
---@field Rot FRotator
---@field Velocity FVector
---@field duration float
local FB2MoveRequest = {}



---@class FB2OverrideSkinData
---@field OriginalSkinColorApplyMode EB1SkinColorApplyMode
---@field OriginalSkinId FName
---@field OriginalSkinColorId FName
---@field OverrideSkinId FName
---@field OverrideSkinColorId FName
local FB2OverrideSkinData = {}



---@class FB2ParkingPlace
---@field SiteId FName
---@field Location FVector
---@field Rotation FRotator
---@field OwnerCharacterId FB1EntityId
---@field VehicleId FB1EntityId
local FB2ParkingPlace = {}



---@class FB2PathFollower
---@field CurrentNodeIndex int32
---@field LastLocation FVector
---@field AcceptanceRadius float
---@field Nodes TArray<FB1NavigationNode>
---@field Method EB1NavigationNodeType
---@field PauseReason TSet<EB1PathFollowingPasue>
---@field bSprint boolean
---@field LaneState EB1CityGraphLaneState
---@field bWaitTrafficSignal boolean
---@field bArrivedAtWaitingArea boolean
---@field CrossWalkSlotIndex int32
local FB2PathFollower = {}



---@class FB2PendingOutfitList
---@field bIsRemove boolean
---@field OutfitSetting FB1OutfitSetting
---@field CostumeTag FName
local FB2PendingOutfitList = {}



---@class FB2PocketMarketPurchasedShoppingItem
---@field TextId FString
---@field Price int64
---@field Icon TSoftObjectPtr<UObject>
---@field PurchasedTime FDateTime
local FB2PocketMarketPurchasedShoppingItem = {}



---@class FB2PocketMarketPurchasedShoppingItemsWrapper
---@field PurchasedShoppingItems TArray<FB2PocketMarketPurchasedShoppingItem>
local FB2PocketMarketPurchasedShoppingItemsWrapper = {}



---@class FB2PocketMarketSellingItem
---@field SellHours TArray<int32>
---@field Name FText
---@field CurrentSellPercentage float
---@field PendingSellPercentageToAdd float
---@field bIsSold boolean
---@field SoldTime FDateTime
---@field Likes int32
---@field Price int64
---@field HoursPassed int32
---@field Quality EB1Quality
---@field DiscountPricePercentage float
---@field ObjectId FName
local FB2PocketMarketSellingItem = {}



---@class FB2PocketMarketSellingItemsWrapper
---@field SellingItems TMap<FB1EntityId, FB2PocketMarketSellingItem>
local FB2PocketMarketSellingItemsWrapper = {}



---@class FB2PocketMarketShoppingItem
local FB2PocketMarketShoppingItem = {}


---@class FB2PopulationLogSystem
local FB2PopulationLogSystem = {}


---@class FB2PortalHandler
---@field EntityID FB1EntityId
---@field CurrentPhase EB2PortalPhase
---@field Param FB2PortalWarpParam
---@field bCompleteLoad boolean
---@field bEnterAnimEnded boolean
---@field bExitAnimEnded boolean
local FB2PortalHandler = {}



---@class FB2PortalWarpParam
---@field EnterPosition FVector
---@field EnterRotation FRotator
---@field ExitPosition FVector
---@field ExitRotation FRotator
local FB2PortalWarpParam = {}



---@class FB2ReactionHistory
---@field CharacterId FB1EntityId
---@field RemainTime float
---@field Result FString
local FB2ReactionHistory = {}



---@class FB2ReactionInfo
---@field ReactionId FName
---@field AnimId FName
---@field AnimType EB1ReactionAnimType
---@field IsReactionRecipient boolean
local FB2ReactionInfo = {}



---@class FB2ReplaceContentDataParams
local FB2ReplaceContentDataParams = {}


---@class FB2RootMotionMovementParams
---@field bHasRootMotion boolean
---@field RootMotionTransform FTransform
local FB2RootMotionMovementParams = {}



---@class FB2ScriptContext
---@field SelfEntityId FB1EntityId
---@field TargetEntityId FB1EntityId
---@field PredictedParam int32
---@field TargetLocation FVector
---@field Reason EB1ScriptReason
local FB2ScriptContext = {}



---@class FB2SelectContextList
---@field AvailableTicks int64
---@field ContextList TArray<FB1ServiceSelectContext>
local FB2SelectContextList = {}



---@class FB2ServiceSpawnContext
---@field EntitySpawnerIds TArray<FB1EntityId>
---@field MeshSpawner TWeakObjectPtr<UB2MeshSpawner>
---@field MeshDescriptionId FName
local FB2ServiceSpawnContext = {}



---@class FB2SetSkillLevelParams
local FB2SetSkillLevelParams = {}


---@class FB2SharedSiteSpawnerGroup
---@field GroupTag FName
---@field Location FVector
local FB2SharedSiteSpawnerGroup = {}



---@class FB2SiteEventBase
---@field EventDtId FName
---@field SiteEventId FB1SiteEventId
---@field EventType EB1SiteEventType
---@field HostEntityId FB1EntityId
---@field CurrentState EB1SiteEventState
---@field EventStartTime int64
---@field EventEndTime int64
---@field SiteId FName
---@field ScheduleInfoId FName
---@field MemberRoleInfos TMap<FB1EntityId, FName>
---@field StageRoleDatas TMap<FName, FB1SiteEventStageRoleData>
---@field StartTimeTaskId FB1TimeTaskId
---@field FinishTimeTaskId FB1TimeTaskId
---@field CachedAutonomyRoleRewardData TMap<FName, FB1SiteEventRoleAutonomyData>
local FB2SiteEventBase = {}



---@class FB2SiteEvent_Fire : FB2SiteEventBase
local FB2SiteEvent_Fire = {}


---@class FB2SiteEvent_Social : FB2SiteEventBase
---@field CustomEventName FString
---@field IsScenarioFlag boolean
---@field RoleTeleportTimeTaskIdMap TMap<FName, FB1TimeTaskId>
local FB2SiteEvent_Social = {}



---@class FB2SituationHint
local FB2SituationHint = {}


---@class FB2SlotStateInfo
---@field SlotName FName
---@field ComponentName FName
---@field OccupyingEntityId FB1EntityId
---@field SlotOccupyingReasons TArray<EB1SlotOccupyingReason>
---@field bLocked boolean
local FB2SlotStateInfo = {}



---@class FB2SocialCluster
local FB2SocialCluster = {}


---@class FB2SocialEventAction
---@field SiteEventId FB1SiteEventId
---@field SiteId FName
---@field SocialEventDtId FName
---@field RoleText FText
---@field ActionInfo FB1SocialEventActionInfo
---@field EventState EB1SocialEventActionState
---@field MemberPool TArray<FB1EntityId>
---@field PlayingActionMemberMap TMap<FB1EntityId, EB1SocialEventActionMemberResult>
---@field PlayActionMemberCount int32
---@field CoopIds TArray<FName>
---@field EventActionTimeTaskIdMap TMap<FB1EntityId, FB1TimeTaskId>
local FB2SocialEventAction = {}



---@class FB2StatDiffLog
---@field StatDiffs TMap<FName, float>
local FB2StatDiffLog = {}



---@class FB2StatProcessData
local FB2StatProcessData = {}


---@class FB2StatResolvableInteractionInfo
---@field EntityID FB1EntityId
---@field InteractionBagId FName
---@field Reward int32
---@field IsSiteEventActivity boolean
local FB2StatResolvableInteractionInfo = {}



---@class FB2State
---@field StateGroupId FName
---@field StateId FName
---@field StartTime int64
---@field Priority int32
local FB2State = {}



---@class FB2SubActionBase
---@field SubActionType EB1SubActionType
---@field bTryStart boolean
---@field bIsActive boolean
---@field CurrentAnimTime float
---@field AnimId FName
---@field CurrentPlayingMontageId FName
---@field NotifyScriptIds TArray<FName>
---@field AnimNotifyCount int32
---@field OwnerEntityId FB1EntityId
---@field TargetEntityId FB1EntityId
---@field Param FB1SubActionParam
---@field AnimState EB2SubActionAnimState
---@field RemainAnimTime float
local FB2SubActionBase = {}



---@class FB2SubActionHistory
---@field Type EB1SubActionType
---@field TargetId FB1EntityId
---@field Cooltime float
---@field ResetRadiusSq float
---@field Reason FString
local FB2SubActionHistory = {}



---@class FB2SubAction_Avoidance : FB2SubActionBase
local FB2SubAction_Avoidance = {}


---@class FB2SubAction_AvoidanceVehicle : FB2SubActionBase
local FB2SubAction_AvoidanceVehicle = {}


---@class FB2SubAction_Greeting : FB2SubActionBase
local FB2SubAction_Greeting = {}


---@class FB2SubAction_PlayAnim : FB2SubActionBase
---@field SubActionAnimDataId FName
local FB2SubAction_PlayAnim = {}



---@class FB2SubAction_Reaction : FB2SubActionBase
---@field ReactionInfo FB2ReactionInfo
---@field Histories TArray<FB2ReactionHistory>
local FB2SubAction_Reaction = {}



---@class FB2SubAction_TakeOffShoes : FB2SubActionBase
---@field bTakeOffShoes boolean
---@field bDoorOverlapped boolean
local FB2SubAction_TakeOffShoes = {}



---@class FB2SubAction_Talk : FB2SubActionBase
local FB2SubAction_Talk = {}


---@class FB2TalkAnimParam
---@field BodyAnimId FName
---@field FaceAnimId FName
---@field SoundId FName
---@field ForceAnimationLength float
---@field bFullBody boolean
---@field LookAtTarget FB1EntityId
---@field ChitchatRelationshipId FName
---@field ChitchatRelationshipValue float
local FB2TalkAnimParam = {}



---@class FB2TalkBehaviorParam
---@field AnimType EB2TalkAnimType
---@field BehaviorType EB2TalkBehaviorType
---@field StartScriptIds TArray<FName>
---@field FinishScriptIds TArray<FName>
local FB2TalkBehaviorParam = {}



---@class FB2TalkCharacterInfo
---@field State EB2TalkCharacterState
---@field UnableExtraTalk boolean
---@field ExecutedTalkCount int32
---@field ExecutingTalkParam FB2ExecutingTalkParam
---@field TalkExecuting boolean
---@field RoleParam FB2TalkRoleParam
---@field SpaceParam FB2TalkSpaceParam
---@field AnimParam FB2TalkAnimParam
---@field BehaviorParam FB2TalkBehaviorParam
local FB2TalkCharacterInfo = {}



---@class FB2TalkCluster
---@field ClusterEntityId FB1EntityId
---@field ClusterArea FB1SafetyBox
---@field AreaLocations TArray<FB2AreaLocationData>
local FB2TalkCluster = {}



---@class FB2TalkInstance
---@field TalkInstanceId FB1TalkInstanceId
---@field Characters TMap<FB1EntityId, FB2TalkCharacterInfo>
---@field BaseLocation FVector
---@field BaseHostLocation FVector
---@field BaseSiteId FB1EntityId
---@field bNearFirstTalkTarget boolean
---@field bProperFirstTalkDistance boolean
---@field ClusterPoints TArray<FVector>
---@field TalkParam FB2TalkParam
---@field FirstTalkQueue TArray<FB2FirstTalkParam>
---@field RemainTalkCount int32
---@field Cluster FB2TalkCluster
---@field FixedTalkArea FB1SafetyBox
---@field MoveToPoints TArray<FVector>
---@field TryProceedTalkTimeTaskId FB1TimeTaskId
local FB2TalkInstance = {}



---@class FB2TalkParam
---@field bIsSet boolean
---@field CoopId FName
---@field TalkType EB2TalkType
local FB2TalkParam = {}



---@class FB2TalkRoleParam
---@field Role EB2TalkRole
---@field InteractionBagId FName
local FB2TalkRoleParam = {}



---@class FB2TalkSpaceParam
---@field Point FVector
---@field SitEntityId FB1EntityId
---@field TargetPoint FVector
---@field bNeedRepositioning boolean
---@field UsingAreaIndex int32
local FB2TalkSpaceParam = {}



---@class FB2TargetSlotParam
---@field SlotName FName
---@field UsageType EB1SlotUsageType
---@field PostureDirection EB1SlotDirection
---@field OccupyEntityId FB1EntityId
---@field bDoNotCheckOccupyEntityId boolean
---@field bUseInteractionTagSlot boolean
---@field OccupyingReason EB1SlotOccupyingReason
---@field OccupyInteractionId FName
---@field bCheckOwnershipSlot boolean
---@field TargetSlotLocation FVector
---@field bSetTargetSlotLocation boolean
local FB2TargetSlotParam = {}



---@class FB2TaskProgressData
---@field TargetId FB1EntityId
---@field CurrentInteractionBagIndex int32
local FB2TaskProgressData = {}



---@class FB2TemporaryAppearanceData
---@field Type EB1TemporaryChangeAppearanceType
---@field ExpireTime FDateTime
local FB2TemporaryAppearanceData = {}



---@class FB2TimeTask_AddHouseholdMonitoringNotification : FB2TimeTask_Base
---@field HouseholdEntityId FB1EntityId
---@field HouseholdMonitoringNotificationId FName
---@field SelfEntityId FB1EntityId
---@field TargetEntityId FB1EntityId
local FB2TimeTask_AddHouseholdMonitoringNotification = {}



---@class FB2TimeTask_AutonomyCrowd : FB2TimeTask_Base
---@field OwnerEntityId FB1EntityId
local FB2TimeTask_AutonomyCrowd = {}



---@class FB2TimeTask_BabyNeglectWarningMessage : FB2TimeTask_Base
---@field HouseholdId FB1EntityId
---@field InstigatorCharacterEntityId FB1EntityId
local FB2TimeTask_BabyNeglectWarningMessage = {}



---@class FB2TimeTask_BabysitterService : FB2TimeTask_Base
---@field HouseholdId FB1EntityId
---@field InstigatorCharacterEntityId FB1EntityId
local FB2TimeTask_BabysitterService = {}



---@class FB2TimeTask_Base
---@field ID FB1TimeTaskId
---@field NextTriggerTicks int64
---@field ExecuteCount int64
---@field IntervalTicks int64
local FB2TimeTask_Base = {}



---@class FB2TimeTask_CheatStartAging : FB2TimeTask_Base
---@field SelfEntityId FB1EntityId
local FB2TimeTask_CheatStartAging = {}



---@class FB2TimeTask_CheatUnlockProfileData : FB2TimeTask_Base
---@field SelfEntityId FB1EntityId
---@field TargetEntityId FB1EntityId
---@field ProfileType FName
local FB2TimeTask_CheatUnlockProfileData = {}



---@class FB2TimeTask_CheckRumorLifeTime : FB2TimeTask_Base
local FB2TimeTask_CheckRumorLifeTime = {}


---@class FB2TimeTask_DelayRabbitHoleInteraction : FB2TimeTask_Base
---@field OwnerEntityId FB1EntityId
---@field AddedTicks int64
local FB2TimeTask_DelayRabbitHoleInteraction = {}



---@class FB2TimeTask_DistributeRunScript : FB2TimeTask_Base
---@field OwnerEntityId FB1EntityId
---@field TargetEntityIds TArray<FB1EntityId>
---@field RunScriptIds TArray<FName>
---@field ScriptReason EB1ScriptReason
---@field OneTickRunScriptCount int32
---@field CurrentIndex int32
local FB2TimeTask_DistributeRunScript = {}



---@class FB2TimeTask_FinishSiteEvent : FB2TimeTask_Base
---@field SiteEventId FB1SiteEventId
local FB2TimeTask_FinishSiteEvent = {}



---@class FB2TimeTask_FlushTalkInstance : FB2TimeTask_Base
local FB2TimeTask_FlushTalkInstance = {}


---@class FB2TimeTask_LevelUpSkill : FB2TimeTask_Base
---@field OwnerEntityId FB1EntityId
---@field SkillName FName
local FB2TimeTask_LevelUpSkill = {}



---@class FB2TimeTask_OverrideMeshSpawner : FB2TimeTask_Base
---@field EntityID FB1EntityId
---@field OverrideMeshList TArray<FName>
local FB2TimeTask_OverrideMeshSpawner = {}



---@class FB2TimeTask_RefreshSiteEventActionState : FB2TimeTask_Base
---@field SocialEventId FB1SiteEventId
---@field SiteEntityId FB1EntityId
local FB2TimeTask_RefreshSiteEventActionState = {}



---@class FB2TimeTask_RequestDetermine : FB2TimeTask_Base
---@field OwnerEntityId FB1EntityId
---@field ActionKey FB2ActionKey
local FB2TimeTask_RequestDetermine = {}



---@class FB2TimeTask_RescuePlayer : FB2TimeTask_Base
---@field RescueCharacterIds TArray<FB1EntityId>
local FB2TimeTask_RescuePlayer = {}



---@class FB2TimeTask_SendCustomMobileMessage : FB2TimeTask_Base
---@field OwnerEntityId FB1EntityId
---@field CustomMobileMessageId FName
---@field MobileMessageParties FB1MobileMessagePartiesResult
local FB2TimeTask_SendCustomMobileMessage = {}



---@class FB2TimeTask_SendGiftAtSite : FB2TimeTask_Base
---@field OwnerEntityId FB1EntityId
local FB2TimeTask_SendGiftAtSite = {}



---@class FB2TimeTask_SendPreferenceAlert : FB2TimeTask_Base
---@field OwnerEntityId FB1EntityId
local FB2TimeTask_SendPreferenceAlert = {}



---@class FB2TimeTask_SiteActionTrigger : FB2TimeTask_Base
---@field SiteEntityId FB1EntityId
---@field SiteActionTriggerIndex int32
local FB2TimeTask_SiteActionTrigger = {}



---@class FB2TimeTask_SkipMoveWithVehicle : FB2TimeTask_Base
---@field VehicleEntityId FB1EntityId
local FB2TimeTask_SkipMoveWithVehicle = {}



---@class FB2TimeTask_SocialEventAddInteractionBag : FB2TimeTask_Base
---@field OwnerEntityId FB1EntityId
---@field TargetEntityId FB1EntityId
---@field InteractionBagId FName
---@field SocialEventId FB1SiteEventId
---@field EventActionId FName
local FB2TimeTask_SocialEventAddInteractionBag = {}



---@class FB2TimeTask_StartSiteEvent : FB2TimeTask_Base
---@field SiteEventId FB1SiteEventId
local FB2TimeTask_StartSiteEvent = {}



---@class FB2TimeTask_TeleportSiteEvent : FB2TimeTask_Base
---@field SiteEventId FB1SiteEventId
---@field RoleId FName
local FB2TimeTask_TeleportSiteEvent = {}



---@class FB2TimeTask_TryProceedTalkInstance : FB2TimeTask_Base
local FB2TimeTask_TryProceedTalkInstance = {}


---@class FB2TimeTask_TryStartNextChoiceCard : FB2TimeTask_Base
local FB2TimeTask_TryStartNextChoiceCard = {}


---@class FB2UpdateContentSlotNumParams
local FB2UpdateContentSlotNumParams = {}


---@class FB2VehicleLaneChangeDescription
---@field bActive boolean
---@field Before FB1CityGraphDetailPoint
---@field After FB1CityGraphDetailPoint
---@field InitialYaw float
---@field Direction int32
---@field EuclideanDistance float
---@field LaneIndex int32
local FB2VehicleLaneChangeDescription = {}



---@class IB2GrowthChangeInterface : IInterface
local IB2GrowthChangeInterface = {}


---@class UB2AOISystem : UB2GameInstanceSubsystem
local UB2AOISystem = {}


---@class UB2Actor : UB2Entity
---@field LocatedSiteId FB1EntityId
---@field FakeObjectLocatedSiteId FB1EntityId
---@field HouseholdEntityId FB1EntityId
---@field InventoryEntityId FB1EntityId
---@field Location FVector
---@field OldLocation FVector
---@field Rotation FRotator
---@field SnappedCoord2D FIntVector2
---@field bCollisionEnabled boolean
---@field AnimInstances TArray<UB2AnimInstance>
---@field FloorLevel int32
---@field Tags TArray<FName>
local UB2Actor = {}



---@class UB2AmbitionComponent : UB2Component
---@field PlayingAmbitionItemId FName
---@field AmbitionItems TMap<FName, FB1AmbitionState>
---@field CompletedAmbitionItemIds TArray<FName>
---@field UncompletedAmbitionIItemIds TArray<FName>
local UB2AmbitionComponent = {}



---@class UB2AnimInstance : UObject
---@field PlayingComponentName FName
---@field MontageInstances TArray<FB2AnimMontageInstance>
---@field RestoreTransform FB2AnimRestoreTransform
local UB2AnimInstance = {}



---@class UB2AnimationSystem : UB2GameInstanceSubsystem
local UB2AnimationSystem = {}


---@class UB2AppearanceComponent : UB2Component
---@field TemporaryAppearanceDataList TArray<FB2TemporaryAppearanceData>
---@field AppearanceSetting FB1AppearanceSetting
---@field CurrentWeatheringIntensity float
---@field PendingActiveOutfitList TArray<FB2PendingOutfitList>
---@field PendingBaseOutfitCategory EB1OutfitCategory
---@field EffectedBuffIdList TSet<FName>
---@field OverrideSkin FB2OverrideSkinData
local UB2AppearanceComponent = {}



---@class UB2AsyncLoadManager : UB2ManagerBase
---@field RequestAsyncMap TMap<FB1AsyncLoadId, FB1RequestAsyncLoad>
local UB2AsyncLoadManager = {}



---@class UB2AttachMeshComponent : UB2Component
---@field AttachMeshIdList TArray<FName>
---@field CachedTemporaryMeshId FName
local UB2AttachMeshComponent = {}



---@class UB2AutonomyComponent : UB2Component
---@field bAutonomyEnable boolean
---@field AutonomyState EB2AutonomyState
---@field AutonomyPickedStatId FName
---@field AutonomyPickedSiteId FB1EntityId
---@field AutonomyPickedStatTier EB1StatServiceTier
---@field AutonomyPickedInteraction FB2StatResolvableInteractionInfo
---@field UnfoundTargetStatList TArray<FName>
---@field WaitFeedbackInteractionTime float
---@field TransientDesireStatList TArray<FName>
---@field ForceStatId FName
---@field TransientDesireInteractionCount int32
---@field AOISnapSize int32
---@field AutonomyCooltime TMap<FName, int64>
local UB2AutonomyComponent = {}



---@class UB2AvoidanceManager : UB2ManagerBase
local UB2AvoidanceManager = {}


---@class UB2BioComponent : UB2Component
---@field BornDay int32
---@field FreezingAge int32
---@field bPauseAging boolean
---@field PausedAge int32
---@field DeadAge int32
---@field GenderType EB1GenderType
---@field FirstNameData FB1DisplayNameData
---@field LastNameData FB1DisplayNameData
---@field TestVectors TArray<FVector>
---@field LastUpdatedAge int32
---@field bNeedsUpdateAging boolean
---@field bAlreadySpawnedToddler boolean
---@field PrevGrowthStep EB1GrowthStep
---@field CurrGrowthStep EB1GrowthStep
---@field bIsPregnant boolean
---@field CachedParentGeneticOwner FB1CharacterGeneticData
---@field CachedParentGeneticSpouse FB1CharacterGeneticData
---@field CachedBabySpawnData FB1BabyCharacterSpawnData
---@field HasGeneticAppearance boolean
---@field MaxPregnancyCount int32
---@field DiversityInfo FB1DiversityInfo
---@field GenderIdentitySetting FB1GenderIdentitySetting
---@field CachedBellyGroupShapeValue float
local UB2BioComponent = {}



---@class UB2BookObject : UB2CarriableObject
local UB2BookObject = {}


---@class UB2BoxComponent : UB2Component
local UB2BoxComponent = {}


---@class UB2BuffComponent : UB2Component
---@field Buffs TMap<FName, FB1Buff>
---@field BuffTagMap TMap<FName, int32>
---@field BuffTickStatDeltaMap TMap<FName, FB2BuffTickStatDelta>
---@field CurrentAdmitBoostLevel int32
---@field CurrentAdmitBoostTendency EB1EmotionTendency
local UB2BuffComponent = {}



---@class UB2CarriableObject : UB2GameObject
---@field CarriableObjectType EB1CarriableObjectType
---@field CarriableObjectId FName
---@field bAffectSiteGrid boolean
---@field bPutDownOnFloor boolean
---@field bPendingPutDown boolean
---@field PendingFloorLocation FVector
---@field PendingFloorRotation FRotator
local UB2CarriableObject = {}



---@class UB2Character : UB2Actor
---@field LastForceGoHomeTime FDateTime
---@field HiddenReasons TArray<FName>
---@field RemainBabyMovementRestrictedTime float
---@field BabysitterServiceTimeTaskId FB1TimeTaskId
---@field SpaceAttribute uint32
---@field VehicleOwnershipData FB1VehicleOwnershipData
---@field CharacterGroupType EB1CharacterGroupType
---@field Role EB1CharacterRole
---@field UsingCarriableObject FB1EntityId
---@field VoiceId FName
---@field SiteAccessRecordDataMap TMap<FName, FB1SiteAccessRecordData>
---@field BoundSiteId FB1EntityId
---@field HopeLifeId FName
---@field bHasInheritedVehicle boolean
---@field AppearancePresetId FName
---@field AppearanceOutfitPresetId FName
---@field ActionsPerformedInThePastHourHints TMap<FName, FB2SituationHint>
---@field SmartZoiTag FString
---@field PendingPutDownTransform FTransform
---@field PrivateCurrencyMap TMap<FName, int64>
---@field VisitedSites TSet<FName>
---@field SavedHouseholdEntityId FB1EntityId
---@field bDoorPrivilege boolean
---@field bGhostInteractionAvailability boolean
---@field GhostInteractionOnReasons TSet<FName>
---@field PocketMarketGradeInfo FB1PocketMarketGradeInfo
local UB2Character = {}



---@class UB2CharacterMovementComponent : UB2Component
---@field PathFollower FB2PathFollower
---@field PortalHandler FB2PortalHandler
---@field LadderHandler FB2LadderHandler
---@field AvoidanceHandler FB2AvoidanceHandler
---@field MotionWarping FB2MotionWarpingParam
---@field RootMotion FB2RootMotionMovementParams
---@field RootMotion_MontageOnly FB2RootMotionMovementParams
---@field SprintReasonSet TSet<EB1SprintReason>
local UB2CharacterMovementComponent = {}



---@class UB2CharacterSpawner : UB2Spawner
local UB2CharacterSpawner = {}


---@class UB2CharacterStatComponent : UB2StatComponent
local UB2CharacterStatComponent = {}


---@class UB2CheatManager : UCheatManager
---@field StartAgingTimeTaskId FB1TimeTaskId
local UB2CheatManager = {}

---@param LocationId FName
function UB2CheatManager:B2WalkToLocation(LocationId) end
---@param InSelfEntityId int64
---@param InTargetEntityId int64
---@param InProfileType FName
function UB2CheatManager:B2UnlockProfileData(InSelfEntityId, InTargetEntityId, InProfileType) end
---@param bInGhostCondition boolean
function UB2CheatManager:B2ToggleGhostCondition(bInGhostCondition) end
function UB2CheatManager:B2TimelineSLMForceRequest() end
---@param bEnable boolean
function UB2CheatManager:B2TimelineSLM(bEnable) end
---@param InEffectName FName
function UB2CheatManager:B2TestPPEffect(InEffectName) end
---@param LocationId FName
function UB2CheatManager:B2TeleportToLocation(LocationId) end
---@param SpawnRadius int32
---@param DespawnRadius int32
function UB2CheatManager:B2SpreadCrowd(SpawnRadius, DespawnRadius) end
---@param InGameObjectId FName
---@param StateGroupIdAndStateId FName
---@param SpawnDelayTime float
---@param SpawnMaxRange float
function UB2CheatManager:B2SpawnGameObjectScriptTest(InGameObjectId, StateGroupIdAndStateId, SpawnDelayTime, SpawnMaxRange) end
---@param InEntityId int64
function UB2CheatManager:B2SpawnDusty(InEntityId) end
---@param bEnable boolean
function UB2CheatManager:B2SitePathFind_EnableJpsN(bEnable) end
---@param Path FString
function UB2CheatManager:B2Simulation_Snapshot(Path) end
---@param timescale float
function UB2CheatManager:B2Simulation_SetTimeScale(timescale) end
---@param Path FString
function UB2CheatManager:B2Simulation_Restore(Path) end
function UB2CheatManager:B2Simulation_Reset() end
---@param InSiteId FName
function UB2CheatManager:B2ShowSiteInfo(InSiteId) end
---@param InEntityId int64
function UB2CheatManager:B2ShowSimulationPath(InEntityId) end
---@param bInValue boolean
function UB2CheatManager:B2SetWorldGhostVisibility(bInValue) end
---@param EntityID int64
---@param VoiceId FString
function UB2CheatManager:B2SetVoiceId(EntityID, VoiceId) end
---@param bInInvincible boolean
---@param bFullStat boolean
function UB2CheatManager:B2SetInvincible(bInInvincible, bFullStat) end
---@param bInValue boolean
function UB2CheatManager:B2SetGhostInteractionAvailability(bInValue) end
---@param InObjectEntityId int64
---@param InCustomName FString
function UB2CheatManager:B2SetCraftObjectCustomName(InObjectEntityId, InCustomName) end
function UB2CheatManager:B2ScriptExecuteTest() end
---@param bInValue boolean
function UB2CheatManager:B2SavePriceInfoInSite(bInValue) end
---@param EntityID int64
---@param Tag FString
function UB2CheatManager:B2RemoveEntityTag(EntityID, Tag) end
function UB2CheatManager:B2RealTimeSecondsPerGameMinutePrint() end
---@param InSeconds float
function UB2CheatManager:B2RealTimeSecondsPerGameMinuteChange(InSeconds) end
---@param FromX float
---@param FromY float
---@param FromZ float
---@param ToX float
---@param ToY float
---@param ToZ float
---@param bDrawDebugLine boolean
function UB2CheatManager:B2QueryPath(FromX, FromY, FromZ, ToX, ToY, ToZ, bDrawDebugLine) end
function UB2CheatManager:B2PrintAllDoor() end
---@param InPerspectiveId FName
---@param InCategoryId FName
---@param InValue float
function UB2CheatManager:B2Perspective_Script(InPerspectiveId, InCategoryId, InValue) end
---@param InEntityId int64
---@param InPerspectiveId FName
---@param InValue float
function UB2CheatManager:B2Perspective_AddPerspectiveValueTarget(InEntityId, InPerspectiveId, InValue) end
---@param InPerspectiveId FName
---@param InValue float
function UB2CheatManager:B2Perspective_AddPerspectiveValue(InPerspectiveId, InValue) end
---@param InSelfEntityId int64
---@param InTargetEntityId int64
---@param InNeedSpareGrid boolean
function UB2CheatManager:B2PathFindTest_FindPutDownLocation(InSelfEntityId, InTargetEntityId, InNeedSpareGrid) end
---@param X float
---@param Y float
---@param Z float
---@param PriorityX float
---@param PriorityY float
---@param PriorityZ float
function UB2CheatManager:B2PathFindTest_FindNearGridLocation(X, Y, Z, PriorityX, PriorityY, PriorityZ) end
function UB2CheatManager:B2LogGuid() end
---@param TargetEntityId int64
---@param InLifeTriggerId FName
function UB2CheatManager:B2ForceTargetGhost(TargetEntityId, InLifeTriggerId) end
---@param InLifeTriggerId FName
function UB2CheatManager:B2ForceGhostAll(InLifeTriggerId) end
---@param InLifeTriggerId FName
function UB2CheatManager:B2ForceGhost(InLifeTriggerId) end
---@param InSelfEntityId int64
---@param InCraftingId FName
---@param InCount int32
function UB2CheatManager:B2FillInventory_PublishableCraftObject(InSelfEntityId, InCraftingId, InCount) end
---@param InSelfEntityId int64
---@param InObjectDtId FName
---@param InCount int32
function UB2CheatManager:B2FillInventory(InSelfEntityId, InObjectDtId, InCount) end
function UB2CheatManager:B2FamilyTreePrintAll() end
---@param InCharacterEntityId int64
function UB2CheatManager:B2FamilyTreePrint(InCharacterEntityId) end
function UB2CheatManager:B2ExitRabbitHole() end
---@param InCommand FName
---@param InSelfEntityId int64
---@param InTargetEntityId int64
---@param InBaseObject FName
---@param S1 FName
---@param S2 FName
---@param F1 float
---@param F2 float
function UB2CheatManager:B2ExecuteTest(InCommand, InSelfEntityId, InTargetEntityId, InBaseObject, S1, S2, F1, F2) end
---@param InRabbitHoleId FName
---@param InFinishTime int32
function UB2CheatManager:B2EnterRabbitHole(InRabbitHoleId, InFinishTime) end
---@param OwnerEntityId int64
---@param TargetEntityId int64
function UB2CheatManager:B2Divorce(OwnerEntityId, TargetEntityId) end
---@param InDebugBuff FName
function UB2CheatManager:B2DebugBuff(InDebugBuff) end
function UB2CheatManager:B2ConvertInteractionDataIndexToLabel() end
---@param InCommand FName
---@param InSelfEntityId int64
---@param InTargetEntityId int64
---@param InBaseObject FName
---@param InCompareType FName
---@param S1 FName
---@param S2 FName
---@param F1 float
---@param F2 float
function UB2CheatManager:B2ConditionTest(InCommand, InSelfEntityId, InTargetEntityId, InBaseObject, InCompareType, S1, S2, F1, F2) end
---@param ComponentName FString
---@param OnOff boolean
function UB2CheatManager:B2Components_Debug(ComponentName, OnOff) end
---@param bEnable boolean
---@param LimitCount int64
---@param bCollectOnlyUniqueNpc boolean
function UB2CheatManager:B2CollectAutonomyBySLM(bEnable, LimitCount, bCollectOnlyUniqueNpc) end
---@param InEntityId int64
function UB2CheatManager:B2ClearInteractionQueue(InEntityId) end
---@param InDustyValue float
---@param InEntityId int64
function UB2CheatManager:B2CheatSiteDustyValue(InDustyValue, InEntityId) end
---@param InStateGroupId FName
---@param InStateId FName
function UB2CheatManager:B2ChangeState(InStateGroupId, InStateId) end
---@param SpawnCount int32
function UB2CheatManager:B2ChangeCrowdSpawnCount(SpawnCount) end
---@param SelfObjectId FString
---@param InCancelReason FName
function UB2CheatManager:B2CancelCurrentInteraction(SelfObjectId, InCancelReason) end
---@param bEnable boolean
function UB2CheatManager:B2AutonomyBySLMV2(bEnable) end
---@param bEnable boolean
function UB2CheatManager:B2Autonomy_EnableAutonomySystem(bEnable) end
---@param InSocialEventId FName
---@param InGroupType EB1CharacterGroupType
function UB2CheatManager:B2ApplySocialEvent(InSocialEventId, InGroupType) end
---@param InEntityId int64
---@param InServiceId FName
function UB2CheatManager:B2AddServiceTarget(InEntityId, InServiceId) end
---@param InServiceId FName
function UB2CheatManager:B2AddService(InServiceId) end
---@param InTargetEntityId int64
---@param InRecordId FName
---@param InRecordNum int32
function UB2CheatManager:B2AddRelationshipRecord(InTargetEntityId, InRecordId, InRecordNum) end
---@param InTargetEntityId int64
---@param InRecordNum int32
function UB2CheatManager:B2AddRelationshipRandRecordNum(InTargetEntityId, InRecordNum) end
---@param InTargetEntityId int64
---@param InRecordNum int32
function UB2CheatManager:B2AddRelationshipImportantRecordWithoutIcon(InTargetEntityId, InRecordNum) end
---@param InTargetEntityId int64
---@param InRecordNum int32
function UB2CheatManager:B2AddRelationshipImportantRecordWithIcon(InTargetEntityId, InRecordNum) end
---@param OwnerEntityId int64
---@param InQuestId FName
---@param InMissionDtId FName
function UB2CheatManager:B2AddQuest(OwnerEntityId, InQuestId, InMissionDtId) end
---@param InCount int32
---@param InEntityId int64
function UB2CheatManager:B2AddPocketMarketFollowers(InCount, InEntityId) end
---@param InteractionId FName
---@param InSelfEntityId int64
---@param InTargetEntityId int64
---@param ObjX float
---@param ObjY float
---@param ObjZ float
function UB2CheatManager:B2AddInteractionAssignedTarget(InteractionId, InSelfEntityId, InTargetEntityId, ObjX, ObjY, ObjZ) end
---@param InteractionId FName
---@param SelfObjectId FString
---@param ObjX float
---@param ObjY float
---@param ObjZ float
function UB2CheatManager:B2AddInteraction(InteractionId, SelfObjectId, ObjX, ObjY, ObjZ) end
---@param EntityID int64
---@param Tag FString
---@param Expire int32
function UB2CheatManager:B2AddEntityTag(EntityID, Tag, Expire) end
---@param EntityID int64
function UB2CheatManager:B1Who(EntityID) end
---@param InEntityId int64
---@param InCount int32
function UB2CheatManager:B1TraitRelationshipTest(InEntityId, InCount) end
---@param InEntityId int64
---@param InTraitName FString
function UB2CheatManager:B1Trait_RemoveTrait(InEntityId, InTraitName) end
---@param InEntityId int64
---@param InTraitName FString
function UB2CheatManager:B1Trait_AddTrait(InEntityId, InTraitName) end
---@param LocationStr FString
function UB2CheatManager:B1TeleportStr(LocationStr) end
---@param InSiteId FName
function UB2CheatManager:B1TeleportSite(InSiteId) end
function UB2CheatManager:B1TeleportHome() end
---@param Distance float
function UB2CheatManager:B1TeleportForward(Distance) end
---@param X float
---@param Y float
---@param Z float
---@param InEntityId int64
function UB2CheatManager:B1Teleport(X, Y, Z, InEntityId) end
---@param InStatId FName
function UB2CheatManager:B1Stat_RemoveStat(InStatId) end
---@param bOn boolean
function UB2CheatManager:B1Stat_NoChange(bOn) end
function UB2CheatManager:B1Stat_AllStatMin() end
function UB2CheatManager:B1Stat_AllStatMax() end
---@param InStatId FName
---@param InValue float
function UB2CheatManager:B1Stat_AddStatValue(InStatId, InValue) end
---@param InValue float
function UB2CheatManager:B1Stat_AddAllStatValue(InValue) end
---@param InSkillName FString
---@param InSkillLevel int32
function UB2CheatManager:B1Skill_SetSkillLevel(InSkillName, InSkillLevel) end
---@param InSkillName FString
---@param InExpPoint float
function UB2CheatManager:B1Skill_AddSkillExp(InSkillName, InExpPoint) end
---@param bOn boolean
---@param InStatId FName
---@param bUseCondition boolean
function UB2CheatManager:B1SiteInteractionReward_DebugOnScreen(bOn, InStatId, bUseCondition) end
---@param IsOn boolean
function UB2CheatManager:B1ShowInteractionInfo(IsOn) end
---@param IsOn boolean
function UB2CheatManager:B1ShowActionPlayerInfo(IsOn) end
---@param InGrade int32
---@param InEntityId int64
function UB2CheatManager:B1SetObjectWeathering(InGrade, InEntityId) end
---@param InDusty float
function UB2CheatManager:B1SetObjectDusty(InDusty) end
---@param InMeshDescriptionId FName
function UB2CheatManager:B1SetMeshToNearestMeshSpawner(InMeshDescriptionId) end
---@param EmotionName FName
---@param EmotionLevel int32
function UB2CheatManager:B1SetEmotion(EmotionName, EmotionLevel) end
---@param InWeatheringIntensity float
function UB2CheatManager:B1SetClothWeatheringIntensityAll(InWeatheringIntensity) end
---@param InWeatheringIntensity float
function UB2CheatManager:B1SetClothWeatheringIntensity(InWeatheringIntensity) end
---@param InSenderId int64
---@param InDayOfWeekIndex int32
---@param InMessage FString
function UB2CheatManager:B1SendMeetingMessage(InSenderId, InDayOfWeekIndex, InMessage) end
---@param InSenderId int64
---@param InCustomMobileMessageId FName
function UB2CheatManager:B1SendCustomMobileMessageForTax(InSenderId, InCustomMobileMessageId) end
---@param InSenderId int64
---@param InCustomMobileMessageId FName
function UB2CheatManager:B1SendCustomMobileMessage(InSenderId, InCustomMobileMessageId) end
function UB2CheatManager:B1SelectRandomAmbition() end
---@param InEntityId int64
---@param InRabbitHoleInteraction FName
function UB2CheatManager:B1SelectRabbitHoleInteraction(InEntityId, InRabbitHoleInteraction) end
---@param InteractionSequenceId FName
function UB2CheatManager:B1SelectInteractionSequence(InteractionSequenceId) end
---@param InAmbitionId FName
function UB2CheatManager:B1SelectAmbition(InAmbitionId) end
function UB2CheatManager:B1ScriptExcuteTestForTech() end
---@param BaseObject EB1BaseObject
---@param ExecuteType EB1ExecuteType
---@param S1 FString
---@param S2 FString
---@param F1 float
---@param F2 float
function UB2CheatManager:B1ScriptExcuteForce(BaseObject, ExecuteType, S1, S2, F1, F2) end
---@param InScriptId FName
---@param InTargetEntityId int64
function UB2CheatManager:B1RunScriptId(InScriptId, InTargetEntityId) end
---@param bOn boolean
function UB2CheatManager:B1Rumor_SystemOn(bOn) end
---@param bOn boolean
function UB2CheatManager:B1Rumor_DebugOnScreen(bOn) end
---@param InAmbitionId FName
function UB2CheatManager:B1ResetAmbition(InAmbitionId) end
---@param InOutfitCategory EB1OutfitCategory
function UB2CheatManager:B1RemoveOutfitCategory(InOutfitCategory) end
---@param InLifeTriggerId FName
---@param InEntityId int64
function UB2CheatManager:B1RemoveLifeTrigger(InLifeTriggerId, InEntityId) end
---@param InEntityId int64
---@param InHowlingId FName
function UB2CheatManager:B1RemoveHowling(InEntityId, InHowlingId) end
---@param InBuffId FName
function UB2CheatManager:B1RemoveBuff(InBuffId) end
function UB2CheatManager:B1RemoveAllHowling() end
---@param InStatName FString
---@param InAdditionalPoint float
function UB2CheatManager:B1Relationship_AddStatKnownNpc(InStatName, InAdditionalPoint) end
---@param InStatName FString
---@param InAdditionalPoint float
function UB2CheatManager:B1Relationship_AddStat(InStatName, InAdditionalPoint) end
---@param TimelineName FName
function UB2CheatManager:B1Possess_UsingTimeline(TimelineName) end
---@param SiteScheduleName FName
function UB2CheatManager:B1Possess_UsingSiteSchedule(SiteScheduleName) end
---@param InChoiceCardGroupId FName
function UB2CheatManager:B1OpenChoiceCardPopup(InChoiceCardGroupId) end
---@param bOn boolean
---@param InModifierTypeFilter FName
function UB2CheatManager:B1Modifier_DebugOnScreen(bOn, InModifierTypeFilter) end
---@param ObjectDtId FName
---@param Count int32
---@param OwnerEntityId int64
---@param InCarriableDtId FName
function UB2CheatManager:B1MakeObjectToInven(ObjectDtId, Count, OwnerEntityId, InCarriableDtId) end
---@param InCount int32
function UB2CheatManager:B1Job_SimulateRandomRetire(InCount) end
---@param InHopeIndex int32
---@param bInFix boolean
function UB2CheatManager:B1Hope_SetFixValue(InHopeIndex, bInFix) end
---@param InHopeId FName
---@param bEnforceMode boolean
function UB2CheatManager:B1Hope_SelectHope(InHopeId, bEnforceMode) end
function UB2CheatManager:B1Hope_ForceUpdate() end
---@param InIndex int32
function UB2CheatManager:B1Hope_DeSelectIndexHope(InIndex) end
function UB2CheatManager:B1Hope_DeSelectAllHopes() end
---@param TargetEntityId int64
function UB2CheatManager:B1ForceTargetDeath(TargetEntityId) end
function UB2CheatManager:B1ForceSendMessage() end
function UB2CheatManager:B1ForceDeath() end
---@param InForce boolean
function UB2CheatManager:B1ForceCanMarry(InForce) end
---@param bInEnable boolean
function UB2CheatManager:B1EnableFire(bInEnable) end
---@param InCount int32
function UB2CheatManager:B1Dream_Simulate(InCount) end
function UB2CheatManager:B1Dream_RemoveDreamBuff() end
---@param InInteractionBagId FName
function UB2CheatManager:B1Dream_ForceSleepwalkingInteractionBagId(InInteractionBagId) end
---@param InDreamSequenceId FName
function UB2CheatManager:B1Dream_ForceDreamSequenceId(InDreamSequenceId) end
---@param InDreamPoolId FName
function UB2CheatManager:B1Dream_ForceDreamPoolId(InDreamPoolId) end
---@param bOn boolean
function UB2CheatManager:B1Dream_ForceDream(bOn) end
---@param bOn boolean
function UB2CheatManager:B1Dream_FastDreamInterval(bOn) end
---@param InEntityId int32
function UB2CheatManager:B1DestroyVehicle(InEntityId) end
function UB2CheatManager:B1DestroyAllVehicles() end
function UB2CheatManager:B1DestroyAllCharacterWithoutMe() end
function UB2CheatManager:B1DestroyAllCharacterWithoutFamily() end
function UB2CheatManager:B1DestroyAllCharacters() end
---@param InTimeToNextAge float
function UB2CheatManager:B1Custom_StartAging(InTimeToNextAge) end
---@param InEntityId int64
---@param InNewAge int32
function UB2CheatManager:B1Custom_SetAgeAndChangeGrowthStep(InEntityId, InNewAge) end
---@param InEntityId int64
---@param InNewAge int32
function UB2CheatManager:B1Custom_SetAge(InEntityId, InNewAge) end
---@param InRecipeId FName
---@param InCount int32
function UB2CheatManager:B1Crafting_Simulate(InRecipeId, InCount) end
function UB2CheatManager:B1ConditionTestForTech() end
---@param InAmbitionId FName
function UB2CheatManager:B1CompleteAmbition(InAmbitionId) end
---@param IsAllCompleted boolean
function UB2CheatManager:B1CompleteAllAmbition(IsAllCompleted) end
---@param OwnerEntityId int64
function UB2CheatManager:B1ClearInven(OwnerEntityId) end
---@param bInOn boolean
---@param bInAll boolean
function UB2CheatManager:B1BornFireLit(bInOn, bInAll) end
---@param InLevel int32
function UB2CheatManager:B1AutonomyVisualize(InLevel) end
function UB2CheatManager:B1Autonomy_ToggleAutonomyOffSystem() end
---@param InCount int32
---@param InEntityId int64
function UB2CheatManager:B1Autonomy_PickedStat(InCount, InEntityId) end
---@param InCount int32
---@param InEntityId int64
function UB2CheatManager:B1Autonomy_IndependentTrial(InCount, InEntityId) end
---@param bEnable boolean
function UB2CheatManager:B1Autonomy_EnableAutonomyOffSystem(bEnable) end
---@param InTimelineId FName
function UB2CheatManager:B1ApplyOverrideTimeline(InTimelineId) end
---@param InOutfitCategory EB1OutfitCategory
function UB2CheatManager:B1ApplyOutfitCategory(InOutfitCategory) end
---@param bOn boolean
---@param InAOISize int32
---@param InStatId FName
---@param bUseCondition boolean
function UB2CheatManager:B1AOIInteractionReward_DebugOnScreen(bOn, InAOISize, InStatId, bUseCondition) end
---@param InEntityId int64
---@param InModifierId FName
function UB2CheatManager:B1AddModifier(InEntityId, InModifierId) end
---@param InLifeTriggerId FName
---@param InEntityId int64
function UB2CheatManager:B1AddLifeTrigger(InLifeTriggerId, InEntityId) end
---@param InJobId FName
---@param InAddExp int32
function UB2CheatManager:B1AddJobExp(InJobId, InAddExp) end
---@param InEntityId int64
---@param InHowlingId FName
---@param InHowlingEmitterType FName
---@param InMaxEffectRecipientsCount int32
function UB2CheatManager:B1AddHowling(InEntityId, InHowlingId, InHowlingEmitterType, InMaxEffectRecipientsCount) end
---@param InAddExp int32
function UB2CheatManager:B1AddCurrentJobNPCExpForce(InAddExp) end
---@param InAddExp int32
function UB2CheatManager:B1AddCurrentJobExpForce(InAddExp) end
---@param InAddExp int32
function UB2CheatManager:B1AddCurrentJobExp(InAddExp) end
---@param InCurrencyId FName
---@param InValue int32
function UB2CheatManager:B1AddCurrency(InCurrencyId, InValue) end
---@param InBuffId FName
function UB2CheatManager:B1AddBuff(InBuffId) end


---@class UB2ChoiceCardManager : UB2ManagerBase
---@field ChoiceCardEventQueue TArray<FB2ChoiceCardEvent>
---@field CurrentEvent FB2ChoiceCardEvent
---@field TryStartNextChoiceCardTimeTaskId FB1TimeTaskId
local UB2ChoiceCardManager = {}



---@class UB2City : UB2Entity
---@field ID FName
---@field LevelName FName
---@field CurrencyId FName
local UB2City = {}



---@class UB2CityEditManager : UB2ManagerBase
---@field DecorationSpawnCount TMap<FName, FB1DecorationSpawnCountList>
---@field DecorationObjectSpawnList TMap<FName, FB1DecorationObjectList>
---@field DailyLog FB1DailyLog
local UB2CityEditManager = {}



---@class UB2CityGraphManager : UB2ManagerBase
local UB2CityGraphManager = {}


---@class UB2CompanyComponent : UB2Component
---@field CompanyDtId FName
---@field DepartmentInfoMap TMap<FB1DepartmentKey, FB1DepartmentInfo>
---@field RootDepartmentInfoMap TMap<FB1DepartmentKey, FB1RootDepartmentInfo>
---@field Employees TMap<FB1EntityId, FB1EmployeeInfo>
---@field SeatObjectDepartmentMap TMap<FB1EntityId, FB1DepartmentKey>
---@field TodayWorkedEntities TArray<FB1EntityId>
local UB2CompanyComponent = {}



---@class UB2Component : UObject
---@field TickAccDeltaValue float
---@field TickInterval float
---@field TickScale float
---@field bTickEnable boolean
local UB2Component = {}



---@class UB2ControllerSystem : UB2GameInstanceSubsystem
---@field PossessEntityId FB1EntityId
---@field BuildModeSiteEntityId FB1EntityId
---@field LastInputTime double
local UB2ControllerSystem = {}



---@class UB2CoopComponent : UB2Component
---@field ConnectedSchedulerId FB1EntityId
---@field bPlayingCoop boolean
---@field bCoopPlayerReady boolean
---@field bCoopProceed boolean
local UB2CoopComponent = {}



---@class UB2CoopScheduler : UB2Entity
---@field CoopId FName
---@field TimeOutDuration int64
---@field TaskStartedTime int64
---@field StartScriptIds TArray<FName>
---@field FinishScriptIds TArray<FName>
---@field CurrentPhase EB1CoopPhase
---@field CurrentResult EB1CoopResult
---@field bReadyForPhaseStart boolean
---@field HostId FB1EntityId
---@field MainTargetId FB1EntityId
---@field TargetIdList TArray<FB1EntityId>
---@field PickedImpactPoint FVector
---@field CharacterInfos TMap<FB1EntityId, FB2CoopCharacterInfo>
---@field ObjectInfos TMap<FB1EntityId, FB1EntityId>
---@field bCancelCurrentInteraction boolean
local UB2CoopScheduler = {}



---@class UB2CoopScheduler_Coop : UB2CoopScheduler
---@field TaskInfos TArray<FB1TaskInfo>
---@field RoleInfos TArray<FB1RoleInfo>
---@field CoopType EB1CoopType
---@field RoleCharacterMap TMap<FName, FB1EntityId>
---@field TaskProgressMap TMap<FB1EntityId, FB2TaskProgressData>
---@field PendingTasks TArray<FB2CoopPendingTask>
---@field CurrentTaskStep int32
local UB2CoopScheduler_Coop = {}



---@class UB2CoopScheduler_EnterVehicle : UB2CoopScheduler
---@field CoopType EB1CoopType
---@field VehicleId FB1EntityId
---@field CachedMovePoints TMap<FB1EntityId, FVector>
local UB2CoopScheduler_EnterVehicle = {}



---@class UB2CoopScheduler_MoveTogether : UB2CoopScheduler
---@field CoopType EB1CoopType
---@field TeleportTarget TSet<FB1EntityId>
---@field MoveToPoints TArray<FVector>
---@field CachedMovePoints TMap<FB1EntityId, FVector>
---@field bPlayTeleport boolean
---@field bIsHostArrive boolean
local UB2CoopScheduler_MoveTogether = {}



---@class UB2CoopScheduler_Talk : UB2CoopScheduler
---@field CoopType EB1CoopType
---@field HostLocation FVector
---@field HostAnimId FName
---@field HostFaceAnimId FName
---@field HostVoiceId FName
---@field TargetLocation FVector
---@field TargetAnimId FName
---@field TargetFaceAnimId FName
---@field TargetVoiceId FName
---@field TalkArea FB1SafetyBox
---@field MoveToPoints TArray<FVector>
---@field TalkDistance float
---@field CradleTalkDistance float
---@field CoopTalkInfo FB1CoopTalkInfo
---@field bCalculateMoveToPointSimultaneously boolean
local UB2CoopScheduler_Talk = {}



---@class UB2CoopSystem : UB2GameInstanceSubsystem
local UB2CoopSystem = {}


---@class UB2CraftObject : UB2CarriableObject
---@field CraftingObjectData FB1CraftingObjectData
local UB2CraftObject = {}



---@class UB2CraftingComponent : UB2Component
---@field RecipeId FName
---@field CurrentStep int32
---@field bIsCrafting boolean
---@field bPlaySuccessAnimation boolean
---@field bPlayIdleAnimation boolean
---@field Quality EB1Quality
---@field CurrentFilterTargetInfo FB1FilterTargetInfo
---@field CurrentCraftObjectEntityId FB1EntityId
---@field FinalObjectEntityId FB1EntityId
---@field CurrentWorkBenchEntityId FB1EntityId
---@field IsWaitingForStart boolean
---@field ReservedStartCraftingContext FB1StartCraftingContext
local UB2CraftingComponent = {}



---@class UB2CurrencyComponent : UB2Component
---@field CurrencyMap TMap<FName, int64>
local UB2CurrencyComponent = {}



---@class UB2DLDSLMManager : UB2ManagerBase
---@field SmartZoiDataAsset TSoftObjectPtr<UDataAsset>
local UB2DLDSLMManager = {}



---@class UB2DebugManager : UB2ManagerBase
local UB2DebugManager = {}


---@class UB2DebugOptions : UObject
---@field DebugHowling int32
---@field DebugMoveTogether int32
---@field DebugWalkTo int32
---@field DebugVehicle int32
---@field DebugVehicleStopAll int32
---@field DebugVehicleStop1 int32
---@field DebugVehicleStop2 int32
---@field DebugTrafficGreenLightRatio float
---@field DebugRelationshipCoefficient float
---@field DebugNavigation int32
---@field DebugMovement int32
---@field DebugSiteB2 int32
---@field DebugSiteGrid int32
---@field DebugStairSlot int32
---@field DebugFailedFindPathTeleport int32
---@field DebugMoveOver int32
---@field DebugForceInteraction int32
---@field DebugSyncRequestPath int32
---@field DebugPopulation int32
---@field DebugNoOptimize int32
---@field DebugUseMaxInteractionRange int32
---@field DebugUseAdvancedDetourPath int32
---@field DebugUseAutonomyCrowd int32
---@field DebugRelationshipCrowd int32
---@field DebugUseInteractionInterval int32
---@field DebugSlot int32
---@field DebugSocialCluster int32
---@field AutonomySLMV2 int32
---@field TimelineSLM int32
---@field CollectAutonomySLM int32
---@field DebugBanTalk int32
---@field DebugTax int32
---@field DebugScript int32
---@field DebugMobileMessage int32
---@field DebugSiteAction int32
---@field DebugCrowdAutonomy int32
---@field DebugAllowEnterOwnerlessDoor int32
---@field SkipEntityRegisterForPathFindTest int32
---@field UseTalkSpaceRepositioning int32
---@field DebugCrafting int32
---@field DebugCraftingCustomNaming int32
---@field DebugCompact int32
---@field DebugAutonomy int32
---@field DebugCharacter int32
---@field DebugCharacter_Age int32
---@field DebugCharacter_Buff int32
---@field DebugCharacter_EntityTag int32
---@field DebugCharacter_Trait int32
---@field DebugCharacter_Interaction int32
---@field DebugCharacter_Inventory int32
---@field DebugCharacter_Anim int32
---@field DebugCharacter_Job int32
---@field DebugCharacter_Voice int32
---@field DebugCharacter_Emotion int32
---@field DebugCharacter_Stat int32
---@field DebugCharacter_Schedule int32
---@field DebugCharacter_Relationship int32
---@field DebugCharacter_Skill int32
---@field DebugCharacter_Dream int32
---@field DebugCharacter_Ambition int32
---@field DebugCharacter_Hope int32
---@field DebugCharacter_Perspective int32
---@field DebugCharacter_LifeTrigger int32
---@field DebugCharacter_Rumor int32
---@field DebugCharacter_Stuck int32
---@field DebugCharacter_Space int32
---@field DebugCharacter_RabbitHole int32
---@field DebugCharacter_SlotOwnership int32
---@field DebugCharacter_SLM int32
---@field DebugCharacter_Ghost int32
---@field DebugCharacter_Talk int32
---@field DebugCharacter_Preference int32
---@field DebugCharacter_Appearance int32
---@field DebugGameObject int32
---@field DebugGameObject_Slot int32
---@field DebugGameObject_Stat int32
---@field DebugGameObject_EntityTag int32
---@field DebugGameObject_Anim int32
---@field DebugGameObject_ObjectWeathering int32
---@field DebugGameObject_Craft int32
---@field DebugGameObject_Creation int32
local UB2DebugOptions = {}



---@class UB2DoorObject : UB2GameObject
---@field AccessiblePermissionGroup TMap<EB1DoorPermissionMode, EB1DoorPermissionGroup>
---@field DevelopersPermissions TMap<FName, FB1DoorCondition>
---@field PermissionMode EB1DoorPermissionMode
---@field DoorPermissionGroup EB1DoorPermissionGroup
---@field DevelopersPermissionsMessageId FName
---@field EntranceLocation FVector
---@field ExitLocation FVector
---@field DoorObjectData FB1DoorObjectSaveData
local UB2DoorObject = {}



---@class UB2DreamComponent : UB2Component
---@field CurrentPoolId FName
---@field LastToggledTicks int64
---@field SequenceDuration int64
---@field bDreaming boolean
---@field bREM boolean
---@field bSleepwalking boolean
---@field CurrentDreamSequenceId FName
---@field CurrentSleepwalkInteractionBagId FName
---@field ScheduledDreamSequenceId FName
---@field ScheduledBodyAnimId FName
---@field ScheduledFaceAnimId FName
---@field BodyMontageId FName
---@field FaceMontageId FName
local UB2DreamComponent = {}



---@class UB2DrivableVehicleComponent : UB2Component
---@field NumberOfPassengers int32
---@field PassengerMap TMap<EB1VehicleSeat, FB1EntityId>
---@field SeatSocketSlotNameMap TMap<EB1VehicleSeat, FName>
---@field LastTowingCheckTime int64
---@field PendingExitPassengerIdList TArray<FB1EntityId>
local UB2DrivableVehicleComponent = {}



---@class UB2DustyComponent : UB2Component
---@field CurrentDusty float
---@field NextDustyUpdateTime int64
local UB2DustyComponent = {}



---@class UB2DustyObject : UB2GameObject
local UB2DustyObject = {}


---@class UB2EmotionComponent : UB2Component
---@field CurrentEmotionInfo FB1EmotionInfo
---@field EmotionInfoMap TMap<FName, FB1EmotionInfo>
---@field JoyfulBoostingEmotionId FName
---@field AdmitBoostingEmotionId FName
local UB2EmotionComponent = {}



---@class UB2Entity : UObject
---@field EntityID FB1EntityId
---@field LocatedCityId FB1EntityId
---@field bTickEnabled boolean
---@field EntityState uint8
---@field Components TArray<UB2Component>
---@field TickableComponents TArray<UB2Component>
---@field EntityTags TArray<FB2EntityTag>
local UB2Entity = {}



---@class UB2EntityManager : UB2ManagerBase
---@field AllEntitiesMap TMap<FB1EntityId, UB2Entity>
---@field AllEntities TArray<UB2Entity>
---@field EntityCollectionMap TMap<EB2EntityType, FB2EntityCollection>
---@field LazyUpdateEntityStateMap TMap<FB1EntityId, FB2LazyChangeEntityStateData>
---@field PendingDeathEntityIds TSet<FB1EntityId>
---@field SLODChangeInfoList TMap<EB2EntityType, FB1EntitySLODInfoMap>
local UB2EntityManager = {}



---@class UB2EntityMoveComponent : UB2Component
local UB2EntityMoveComponent = {}


---@class UB2EventSystem : UB2GameInstanceSubsystem
local UB2EventSystem = {}


---@class UB2FamilyTreeManager : UB2ManagerBase
---@field idToMemberMap TMap<FB1FamilyTreeMemberId, FB1FamilyTreeMemberData>
local UB2FamilyTreeManager = {}



---@class UB2FenceObject : UB2GameObject
---@field FenceData FB1FenceObjectSaveData
local UB2FenceObject = {}



---@class UB2FoodObject : UB2CarriableObject
---@field AccumulateEatTickTime double
---@field RemainFoodValue int32
---@field TotalFoodValue int32
local UB2FoodObject = {}



---@class UB2GameInstanceSubsystem : UGameInstanceSubsystem
local UB2GameInstanceSubsystem = {}


---@class UB2GameObject : UB2Actor
---@field ObjectTableId FName
---@field Size FVector
---@field CustomizedData TArray<FB1ObjectCustomizeSaveData>
---@field PrintedMeshId FString
---@field PrintedMeshOffset FVector
---@field Scale FVector
---@field ZoneGraphNodeIndex int32
---@field IsDevLocked boolean
---@field AuthorName FString
---@field GalleryPathKey FString
---@field InvisibleObjectDuringInteraction boolean
---@field HideMeshComponentTag FName
---@field AttachedCharacterId FB1EntityId
---@field Quality EB1Quality
---@field PropertyOwnedHouseholdEntityId FB1EntityId
---@field SalePrice int64
---@field SellerEntityId FB1EntityId
---@field QualityId FName
---@field ObjectType EB2GameObjectDetailType
---@field OwnerEntityId FB1EntityId
---@field CachedPrice int64
---@field bIsNonSiteObject boolean
---@field AssembledAssetHash int64
local UB2GameObject = {}



---@class UB2GameObjectStatComponent : UB2StatComponent
local UB2GameObjectStatComponent = {}


---@class UB2GameObjectSystem : UB2GameInstanceSubsystem
local UB2GameObjectSystem = {}


---@class UB2GeneratedMotionSlotManager : UB2ManagerBase
local UB2GeneratedMotionSlotManager = {}


---@class UB2GiftManager : UB2ManagerBase
---@field GiftDataMap TMap<FB1EntityId, FB1RelationshipGiftData>
---@field GiftOwnerMap TMap<FB1EntityId, FB1EntityIdArray>
---@field GiftBoxSpawnPointIndexMap TMap<FB1EntityId, int32>
local UB2GiftManager = {}



---@class UB2HopeComponent : UB2Component
---@field SelectedHopes TArray<FB2HopeSlotInfo>
---@field DeSelectedHopes TMap<FName, int64>
local UB2HopeComponent = {}



---@class UB2Household : UB2Entity
---@field HouseholdNameData FB1DisplayNameData
---@field HouseholdDescriptionTextId FString
---@field HouseholdTextureId FName
---@field Members TArray<FB1EntityId>
---@field ResidanceSiteId FB1EntityId
---@field bCanMoveIn boolean
---@field SaleObjectList TArray<FB1EntityId>
local UB2Household = {}



---@class UB2HouseholdMonitoringComponent : UB2Component
---@field HouseholdMonitoringNotificationList TArray<FB1HouseholdMonitoringNotificationData>
---@field UnreadHouseholdMonitoringNotificationCount int32
---@field CurrentTimeTaskIds TArray<FB1TimeTaskId>
local UB2HouseholdMonitoringComponent = {}



---@class UB2HowlingComponent : UB2Component
---@field CooltimeMap TMap<FName, int64>
---@field InteractionListFromHowling TArray<FName>
local UB2HowlingComponent = {}



---@class UB2HowlingEmitter : UB2Entity
---@field HowlingId FName
---@field HowlingEmitterType EB1HowlingEmitterType
---@field FrequencyInfo FB1FrequencyInfo
---@field EffectsInfo FB1EffectsInfo
---@field AttachedEntityId FB1EntityId
---@field Location FVector
---@field Rotation FRotator
---@field MaxEffectRecipientsCount int32
---@field CurrentEffectRecipientsCount int32
---@field LastInvokeTime int64
---@field EntireAccumTickTime int64
---@field CreateTickTime int64
---@field bImmediate boolean
---@field bRequestedDestroy boolean
---@field bIsDestroy boolean
---@field AppliedTargetList TArray<FB1EntityId>
local UB2HowlingEmitter = {}



---@class UB2HowlingEmitter_Trend : UB2HowlingEmitter
---@field TargetSiteEntityId FB1EntityId
local UB2HowlingEmitter_Trend = {}



---@class UB2HowlingEmitter_VehicleAccident : UB2HowlingEmitter
---@field bTriggered boolean
local UB2HowlingEmitter_VehicleAccident = {}



---@class UB2HowlingSystem : UB2GameInstanceSubsystem
local UB2HowlingSystem = {}


---@class UB2InstinctComponent : UB2Component
local UB2InstinctComponent = {}


---@class UB2InteractionComponent : UB2Component
---@field InteractionQueue TArray<FB2InteractionQueue>
---@field PendingCancelQueueIds TMap<int64, EB1InteractionCancelReason>
---@field CurrentTargetSlot FB2TargetSlotParam
---@field InteractionQueueIdCounter int64
local UB2InteractionComponent = {}



---@class UB2InteractionTrackingComponent : UB2Component
---@field ResetDelayTime int64
---@field IdActionTimeMap TMap<FName, FB1ActionTimeData>
---@field TagActionTimeMap TMap<FName, FB1ActionTimeData>
---@field InteractionHistory TArray<FName>
local UB2InteractionTrackingComponent = {}



---@class UB2Inventory : UB2Entity
---@field InventoryDtId FName
---@field OwnerEntityId FB1EntityId
---@field OwnedEntityIds TArray<FB1EntityId>
---@field PutDownEntityId FB1EntityId
---@field Context FB2ScriptContext
---@field OwnerEntityType EB2EntityType
local UB2Inventory = {}



---@class UB2JobComponent : UB2Component
---@field JobInfos TMap<FName, FB1JobInfo>
---@field CareerList TArray<FB1CareerInfo>
---@field CompanyEntityId FB1EntityId
---@field CurrentModifierId FName
---@field SeatEntityId FB1EntityId
---@field WorkState EB1WorkState
---@field NextTimeScheduleIndex int32
---@field StartWorkTicks int64
---@field EndWorkTicks int64
---@field MaxEndWorkTicks int64
---@field bIsAttandance boolean
---@field bIsArriveAtCompanyArea boolean
---@field bIsSetWorkMission boolean
---@field ReserveJobPromotionData FB1JobSearchJobData
---@field CurrentWorkMissionId FName
---@field HighestEducationData FB1HighestEducationData
local UB2JobComponent = {}



---@class UB2KarmaReportManager : UB2ManagerBase
---@field KarmaReportCoolTimeList TMap<FB1EntityId, int64>
local UB2KarmaReportManager = {}



---@class UB2LadderObject : UB2GameObject
---@field LadderData FB1LadderObjectSaveData
local UB2LadderObject = {}



---@class UB2LifeComponent : UB2Component
---@field AccumulatedTick float
---@field LifeTriggerMap TMap<FName, FB1LifeTriggerDetailData>
---@field bForceCanMarry boolean
---@field bCanGhost boolean
---@field LastTriggerId FName
---@field BoundSiteType EB1SiteType
---@field IsTriggered boolean
local UB2LifeComponent = {}



---@class UB2LocatorElevatorObject : UB2GameObject
---@field TeleportLocation FVector
local UB2LocatorElevatorObject = {}



---@class UB2ManagerBase : UObject
local UB2ManagerBase = {}


---@class UB2MeetingManager : UB2ManagerBase
---@field MeetingWatingData TArray<FB2MeetingWatingData>
---@field NextMeetingMathcingTicks int64
local UB2MeetingManager = {}



---@class UB2MeshSpawner : UB2Spawner
---@field DefaultMeshIdList TArray<FName>
---@field OverrideMeshIdList TArray<FName>
local UB2MeshSpawner = {}



---@class UB2MissionComponent : UB2Component
---@field MissionMap TMap<FB1MissionId, FB1MissionState>
---@field MissionIdByWorldMissionDtId TMap<FName, FB1MissionId>
---@field ActiveMissionIdByCondition TMap<EB1MissionCondition, FB1MissionIdList>
---@field TriggersList TArray<FB1MissionConditionTriggerList>
---@field TriggersIndex uint8
local UB2MissionComponent = {}



---@class UB2MobileMessageComponent : UB2Component
---@field PendingResponseReply TArray<FB1ResponseReplyRequest>
---@field MessageList FB1MobileMessageListMap
---@field MessageListBySystem FB1MobileMessageListBySystemMap
---@field MessageCooltime FB1MobileMessageCooltimeMap
---@field bSendMessage boolean
---@field bSetMessageTime boolean
---@field SendMessageHour int32
---@field SendMessageMinute int32
---@field CurrentTimeTaskIds TArray<FB1TimeTaskId>
local UB2MobileMessageComponent = {}



---@class UB2ModifierComponent : UB2Component
local UB2ModifierComponent = {}


---@class UB2NonCarriableCraftObject : UB2GameObject
---@field CraftingObjectData FB1CraftingObjectData
local UB2NonCarriableCraftObject = {}



---@class UB2ObjectGroupingComponent : UB2Component
---@field RootEntityId FB1EntityId
---@field ParentEntityId FB1EntityId
---@field ChildrenEntityIds TSet<FB1EntityId>
---@field GroupingEntityIds TSet<FB1EntityId>
---@field OccupiedSlotName FName
local UB2ObjectGroupingComponent = {}



---@class UB2ObjectWeatheringComponent : UB2Component
---@field bIsEnableWeathering boolean
---@field bIsWeatheringEnabled boolean
---@field WeatheringGroupName FName
---@field CurrentGrade int32
---@field RemainNextGradeDay int32
---@field CurrentWeatheringIntensity float
---@field BaseDay int32
local UB2ObjectWeatheringComponent = {}



---@class UB2PacketSystem : UB1PacketSystemBase
local UB2PacketSystem = {}


---@class UB2PathFindSystem : UB2GameInstanceSubsystem
---@field NavigationData ANavigationData
---@field NavigationSubsystem UNavigationSystemV1
---@field PathFindConfig UB1PathFindConfig
local UB2PathFindSystem = {}



---@class UB2PedestrianLaneSystem : UB2GameInstanceSubsystem
local UB2PedestrianLaneSystem = {}


---@class UB2PerspectiveComponent : UB2Component
---@field Perspectives TMap<FName, FB1Perspective>
---@field bIsMainPerspectiveChange boolean
---@field bIsEnableDailyPopup boolean
local UB2PerspectiveComponent = {}



---@class UB2PerspectiveSystem : UB2GameInstanceSubsystem
local UB2PerspectiveSystem = {}


---@class UB2PillarObject : UB2GameObject
---@field PillarObjectData FB1PillarObjectSaveData
local UB2PillarObject = {}



---@class UB2PocketMarketManager : UB2ManagerBase
---@field CharacterSellingItems TMap<FB1EntityId, FB2PocketMarketSellingItemsWrapper>
---@field CharacterPurchasedShoppingItems TMap<FB1EntityId, FB2PocketMarketPurchasedShoppingItemsWrapper>
local UB2PocketMarketManager = {}



---@class UB2PopulationSystem : UB2GameInstanceSubsystem
---@field GeneratedFamilyInc int32
---@field GeneratedHasJobNpcFamilyInc int32
---@field GeneratedNoJobNpcFamilyInc int32
---@field DiversityPopulationInfo FB1DiversityPopulationInfo
---@field TotalGeneratedCrowdCount int32
---@field MaxSpawnCrowdCount int32
---@field InitializeCrowdCount int32
---@field ActivateCrowds TArray<FB1EntityId>
---@field WaitingCrowds TArray<FB1EntityId>
---@field WaitingCrowdLookupTable TMap<FB1EntityId, int32>
---@field SiteScheduleLookupTable TMap<FName, FName>
---@field DiversityCharacters TSet<FB1EntityId>
local UB2PopulationSystem = {}



---@class UB2PostureComponent : UB2Component
---@field CurrentPostureState FB1PostureState
---@field GrabStates TMap<EB1HandType, FB1GrabState>
---@field OneTimePostureAnimIds TArray<FName>
local UB2PostureComponent = {}



---@class UB2PreferenceComponent : UB2Component
---@field PreferenceMap TMap<FName, boolean>
---@field PreferenceBuffMap TMap<FName, FB1PreferenceBuffData>
---@field MaxPreferenceCount int32
local UB2PreferenceComponent = {}



---@class UB2PrintedObject : UB2GameObject
---@field PrintedObjectData FB1PrintedObjectSaveData
local UB2PrintedObject = {}



---@class UB2QuestComponent : UB2Component
---@field ExecutingQuestMap TMap<FName, FB1ExecuteQuest>
---@field ReserveQuestHeap TArray<FB1ReserveQuest>
---@field TodayQuestHistoryData TMap<FName, FB1QuestHistoryData>
---@field PendingRemoveHistoryDataList TArray<FB1RemoveQuest>
---@field PendingUpdateHistoryDataList TArray<FB1UpdateQuest>
local UB2QuestComponent = {}



---@class UB2RabbitHoleComponent : UB2Component
---@field CurrentRabbitHoleId FName
---@field CurrentRabbitHoleInteractionId FName
---@field InteractionStartTime int64
---@field ChoiceCards TArray<FB1ChoiceCardTimeInfo>
---@field DelayRabbitHoleInteractionTimeTaskId FB1TimeTaskId
local UB2RabbitHoleComponent = {}



---@class UB2RelationshipComponent : UB2Component
---@field GiftSendTimerId int64
---@field SiteGiftSendTimeMap TMap<FName, int64>
---@field RelationshipMap TMap<FB1EntityId, FB1RelationshipData>
---@field RelationshipEventMap TMap<FName, FB1RelationshipEventDataList>
---@field CurrentRelationshipEvent TSet<FName>
local UB2RelationshipComponent = {}



---@class UB2RelationshipEventDefine : UObject
local UB2RelationshipEventDefine = {}


---@class UB2RelationshipSystem : UB2GameInstanceSubsystem
local UB2RelationshipSystem = {}


---@class UB2RoofObject : UB2GameObject
---@field RoofObjectData FB1RoofObjectSaveData
local UB2RoofObject = {}



---@class UB2RumorManager : UB2ManagerBase
---@field RumorContainer TMap<FB1RumorId, FB1RumorParam>
---@field EntityKnownTheRumorContainer TMap<FB1EntityId, FB1RumorIdList>
---@field LastRumorId FB1RumorId
---@field CheckRumorLifeTimeTaskId FB1TimeTaskId
local UB2RumorManager = {}



---@class UB2ServiceManager : UB2ManagerBase
---@field SelectContextMap TMap<FName, FB2SelectContextList>
---@field ExecuteContextMap TMap<FName, FB2ExecuteContextList>
---@field TimelineScriptContext FB2ScriptContext
---@field FinishScriptContext FB2ScriptContext
---@field SelectExecuteConnections TArray<FB1ServiceSelectExecuteConnection>
---@field ServiceJobPool TMap<FName, FB2JobEntityPool>
---@field ServiceJobLookupTable TMap<FB1EntityId, FName>
---@field SpawnContexts TMap<FB1ServiceContextId, FB2ServiceSpawnContext>
local UB2ServiceManager = {}



---@class UB2ServiceSpawner : UB2Spawner
---@field SpawnIndex int16
local UB2ServiceSpawner = {}



---@class UB2SimulationSystem : UB2GameInstanceSubsystem
---@field Managers TArray<UB2ManagerBase>
local UB2SimulationSystem = {}



---@class UB2Site : UB2Actor
---@field SiteId FName
---@field CompanyId FName
---@field Size FVector
---@field FloorMin int32
---@field FloorMax int32
---@field DustFloorSpawnTime int64
---@field SiteZBound FVector2D
---@field NextTaxChargeTime int64
---@field bIsFakeSite boolean
---@field OwnerHouseholdId FB1EntityId
---@field ParkingPlaces TArray<FB2ParkingPlace>
---@field SiteEntireSaveData FB2SiteEntireSaveData
---@field bTakeOffShoes boolean
---@field DustyObjects TArray<FB1EntityId>
---@field FireEventId FB1SiteEventId
---@field SeizureObjectList TArray<FB1EntityId>
---@field SiteActionTriggerTimeTaskIds TArray<FB1TimeTaskId>
---@field SocialEventUpdateActionTateTimeTaskId FB1TimeTaskId
---@field PendingAddFireInstanceList TMap<FB1FireId, FB2Fire>
---@field PendingDeleteFireInstanceList TArray<FB1FireId>
---@field FireInstanceList TMap<FB1FireId, FB2Fire>
local UB2Site = {}



---@class UB2SiteEventManager : UB2ManagerBase
---@field PlayingZoiSiteEventMap TMap<FB1EntityId, FB1SiteEventIdList>
local UB2SiteEventManager = {}



---@class UB2SiteManager : UB2ManagerBase
---@field SiteMap TMap<FName, UB2Site>
---@field CompanySiteMap TMap<FName, TWeakObjectPtr<UB2Site>>
---@field ResidenceSiteMap TMap<FName, TWeakObjectPtr<UB2Site>>
---@field SiteCheckAvailableFirePosParamList TArray<FB2SiteCheckAvailableFirePosParam>
---@field EducationSiteList TArray<FName>
local UB2SiteManager = {}



---@class UB2SitePathFindingComponent : UB2Component
---@field ReplacingOutlinePoints TArray<FVector>
---@field PortalPoints TArray<FB1PortalData>
---@field GiftBoxPoints TArray<FVector>
---@field bUseVehiclePoint boolean
---@field VehiclePoint FVector
---@field bOnlyReachableByWarp boolean
---@field PathfindingGrid2 TMap<int32, FB1FloorPathFindGrid>
---@field ZoneGraphNodeArray TArray<FB1ZoneGraphNode>
---@field ZoneGraphZoneInfoMap TMap<int32, FB1ZoneGraphZoneInfo>
---@field XCollisionBitArrayMap TMap<int32, FB1PathFindGridBitArray>
---@field YCollisionBitArrayMap TMap<int32, FB1PathFindGridBitArray>
---@field GridMaxX int32
---@field GridMaxY int32
---@field MinFloor int32
---@field MaxFloor int32
---@field ExecutingPathFollowingCharacters TArray<FB1EntityId>
local UB2SitePathFindingComponent = {}



---@class UB2SkillComponent : UB2Component
---@field Skills TMap<FName, FB1Skill>
local UB2SkillComponent = {}



---@class UB2SkillSystem : UB2GameInstanceSubsystem
local UB2SkillSystem = {}


---@class UB2SlotComponent : UB2Component
---@field SlotStateInfos TArray<FB2SlotStateInfo>
---@field UseSlotCompanyIdOnly FB1EntityId
---@field UseSlotEmployeeObjectIdOnly FB1EntityId
---@field UseSlotSchedulerIdOnly FB1EntityId
---@field OccupiedSlotOwner FB1EntityId
---@field OwnershipInfo TMap<FB1EntityId, FName>
---@field UsedSlotOwnershipTags TSet<FName>
local UB2SlotComponent = {}



---@class UB2SootObject : UB2GameObject
---@field PlacementFlag EB1PlacementFlag
---@field bNeedDelayDecal boolean
local UB2SootObject = {}



---@class UB2Spawner : UB2Actor
---@field SpawnCoolTime float
---@field GroupIndex int32
---@field SpawnerActorType EB1SpawnerType
---@field GroupTag FName
local UB2Spawner = {}



---@class UB2SpawnerManager : UB2ManagerBase
---@field SharedSiteSpawnerGroup TMap<FName, FB2SharedSiteSpawnerGroup>
local UB2SpawnerManager = {}



---@class UB2StairsObject : UB2GameObject
---@field StairsData FB1StairsObjectSaveData
local UB2StairsObject = {}



---@class UB2StatComponent : UB2Component
---@field Stats TMap<FName, float>
---@field DesiredStatNum int32
local UB2StatComponent = {}



---@class UB2StatSystem : UB2GameInstanceSubsystem
local UB2StatSystem = {}


---@class UB2StateComponent : UB2Component
---@field States TMap<FName, FB2State>
---@field SpreadLevel int32
---@field SpawnedFireId FB1FireId
---@field SpreadOriginPos FVector
local UB2StateComponent = {}



---@class UB2StuckComponent : UB2Component
local UB2StuckComponent = {}


---@class UB2StudioMannequinObject : UB2GameObject
---@field StudioMannequinObjectData FB1StudioMannequinObjectSaveData
local UB2StudioMannequinObject = {}



---@class UB2SubActionComponent : UB2Component
---@field Histories TArray<FB2SubActionHistory>
local UB2SubActionComponent = {}



---@class UB2TalkComponent : UB2Component
---@field TalkInstanceId FB1TalkInstanceId
---@field bTalkProceed boolean
local UB2TalkComponent = {}



---@class UB2TalkManager : UB2ManagerBase
---@field TalkInstances TMap<FB1TalkInstanceId, FB2TalkInstance>
---@field FinishInstanceIds TArray<FB1TalkInstanceId>
---@field FlushTimeTaskId FB1TimeTaskId
local UB2TalkManager = {}



---@class UB2TargetFilterSystem : UB2GameInstanceSubsystem
local UB2TargetFilterSystem = {}


---@class UB2TaxComponent : UB2Component
---@field ServiceUsages TMap<EB1ServiceType, int32>
---@field ServiceTaxesPerDay TMap<EB1ServiceType, int32>
---@field PreviousDay EB1DayOfWeek
---@field OverDue uint8
---@field CurrentTax int32
---@field TaxChargeState EB1TaxChargeState
---@field bElecticityCutoff boolean
---@field bWaterCutoff boolean
local UB2TaxComponent = {}



---@class UB2TestComponent : UB2Component
local UB2TestComponent = {}


---@class UB2TestGameInstance : UGameInstance
---@field World UWorld
local UB2TestGameInstance = {}



---@class UB2TimeManager : UB2ManagerBase
local UB2TimeManager = {}


---@class UB2TimeTaskManager : UB2ManagerBase
---@field NearestTriggerTicks int64
local UB2TimeTaskManager = {}



---@class UB2TimelineComponent : UB2Component
---@field CachedDayOfWeek EB1DayOfWeek
---@field BaseTimelines TArray<FB1Timeline>
---@field OverrideTimelines TArray<FB1Timeline>
---@field OrderQueue TArray<FB1Order>
---@field SiteExitRemainMinute int32
---@field DestTargetEntityId FB1EntityId
---@field DespawnSpawnerEntityId FB1EntityId
---@field SiteSchedule FB1SiteSchedule
---@field bExecutedCrowdOverrideTimeline boolean
---@field AutonomyTimeTaskId FB1TimeTaskId
---@field CurrentScheduleId FB1ScheduleId
---@field bIsExecuteStartSchedule boolean
---@field bIsExecuteArrivedSchedule boolean
---@field bIsExecuteCancelSchedule boolean
---@field bIsExecuteLeavedSiteSchedule boolean
---@field bIsArrivedDestination boolean
---@field StartWorkingScheduleTime int32
---@field PreviousLocation FVector
---@field bWakeUpExceedScheduleTime boolean
local UB2TimelineComponent = {}



---@class UB2TimelineManager : UB2ManagerBase
local UB2TimelineManager = {}


---@class UB2TrafficDensityControlSystem : UB2GameInstanceSubsystem
local UB2TrafficDensityControlSystem = {}


---@class UB2TrafficIntersection : UObject
local UB2TrafficIntersection = {}


---@class UB2TrafficJamManagementSystem : UB2GameInstanceSubsystem
local UB2TrafficJamManagementSystem = {}


---@class UB2TrafficSignalControlSystem : UB2GameInstanceSubsystem
---@field TrafficLightCache TMap<int32, EB1CityGraphCategory>
local UB2TrafficSignalControlSystem = {}



---@class UB2TrafficSystem : UB2GameInstanceSubsystem
---@field CityGraphTrafficLanes TArray<FB2CityGraphTrafficLane>
---@field CityGraphTrafficVehicleLanes TArray<FB2CityGraphTrafficLane>
---@field CityTrafficPolicy FB1CityTrafficPolicy
---@field SpawnableVehicleDtIdList TArray<FName>
---@field CachedVehicleBounds TMap<FName, FVector>
---@field DrivenVehicles TArray<FB1EntityId>
---@field OwnedVehicles TArray<FB1EntityId>
---@field CityTrafficControlDataAsset UB1CityTrafficControlDataAsset
---@field SpawnRatio float
---@field CachedSimulationDriverData TMap<FName, FB1SimulationDriverData>
local UB2TrafficSystem = {}



---@class UB2TraitComponent : UB2Component
---@field TraitIdList TArray<FName>
---@field TraitForHopeId FName
local UB2TraitComponent = {}



---@class UB2TraitSystem : UB2GameInstanceSubsystem
local UB2TraitSystem = {}


---@class UB2Vehicle : UB2Actor
---@field VehicleDtId FName
---@field OwnerId FB1EntityId
---@field ColorId FName
---@field ColorLookUp float
---@field Policy EB1VehiclePolicy
---@field ControlSubject EB1VehicleControlSubject
---@field RepresentationType EB1VehicleRepresentationType
---@field Speed float
---@field SimulationDriverMeshId FName
---@field PreviousLaneIndex int32
---@field LaneIndex int32
---@field NextLaneIndex int32
---@field RoadIndex int32
---@field NextRoadIndex int32
---@field PreviousLaneUID FName
---@field LaneUID FName
---@field NextLaneUID FName
---@field RoadUID FName
---@field NextRoadUID FName
---@field bTargetOfDestruction boolean
---@field LaneAdvancedDistance float
---@field destination FVector4
---@field SteeringAngle float
---@field InputValue float
---@field bPendingDestory boolean
---@field SimulationDriverId FB1EntityId
---@field ParkingPlaceSiteId FB1EntityId
---@field AccidentTargetId FB1EntityId
---@field NearbyVehicles TArray<UB2Vehicle>
---@field DetectedEntities TArray<UB2Vehicle>
---@field RandomFraction float
---@field HoldSeconds float
---@field DespawnSpeed float
---@field DespawnHoldTime float
---@field VehicleAccidentTriggerSpeed float
---@field DeviationCheckInterval float
---@field DeviationAlertTime float
---@field DeviationRecoveryTime float
---@field DeviationThreshold FVector
---@field AccumulatedDeviationTime float
---@field bDeviationAlertMessageSent boolean
---@field AccumulatedTimeForDeviationCheck float
---@field LaneChangeDescription FB2VehicleLaneChangeDescription
---@field Velocity FVector
---@field PartsState TMap<EB1VehiclePartType, FName>
---@field LightFlag uint8
local UB2Vehicle = {}



---@class UB2VehicleBehaviorDecisionComponent : UB2Component
---@field Vehicle UB2Vehicle
---@field MainTarget FB1EntityId
local UB2VehicleBehaviorDecisionComponent = {}



---@class UB2VehicleCollisionComponent : UB2Component
---@field CollidedEntityMap TMap<FB1EntityId, TWeakObjectPtr<UB2Actor>>
local UB2VehicleCollisionComponent = {}



---@class UB2VehicleLaneChangeComponent : UB2Component
---@field Vehicle UB2Vehicle
local UB2VehicleLaneChangeComponent = {}



---@class UB2VehicleMovementComponent : UB2Component
---@field OverlappedCharacters TSet<FB1EntityId>
---@field TargetEntityId FB1EntityId
---@field TargetEntityPerceiveSeconds float
---@field MovableFlag uint8
local UB2VehicleMovementComponent = {}



---@class UB2VehicleNavigationComponent : UB2Component
---@field Vehicle UB2Vehicle
---@field KeyIndex int32
---@field NavigationPath FB1CityGraphPath
---@field AutoDrivingInteractionQueueId int64
---@field AutoSkipTaskId FB1TimeTaskId
local UB2VehicleNavigationComponent = {}



---@class UB2VehiclePerceptionComponent : UB2Component
---@field Vehicle UB2Vehicle
local UB2VehiclePerceptionComponent = {}



---@class UB2VehicleSimpleNavigationComponent : UB2Component
---@field Vehicle UB2Vehicle
local UB2VehicleSimpleNavigationComponent = {}



---@class UB2WeatherManager : UB2ManagerBase
---@field bEnabled boolean
---@field CurrentSeason EB1SeasonType
---@field SeasonWeatherSchedule FB1WeatherInfo
---@field OverriddenWeatherSchedule FB1WeatherInfo
---@field StoredWeatherSchedule FB1WeatherInfo
---@field PrevSeasonTemperature int32
---@field PrevWeatherSchedule FB1WeatherInfo
local UB2WeatherManager = {}



---@class UB2WorldEventManager : UB2ManagerBase
---@field EventTriggerInfos TArray<FB2EventTriggerInfo>
local UB2WorldEventManager = {}



---@class UB2WorldMissionManager : UB2ManagerBase
---@field CachedMissionCount TMap<FB1EntityId, FB1MissionCountMap>
---@field CharacterMissionRecorder TMap<FB1EntityId, FB1MissionRecorder>
---@field FamilyMissionRecorder TMap<FB1EntityId, FB1MissionRecorder>
---@field WorldMissionRecorder FB1MissionRecorder
---@field CompletedWorldMissionDtKey TArray<FName>
local UB2WorldMissionManager = {}



